/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public class CoordinationSet<N extends Comparable<N>>
extends HashMap<String, CalendarDateSeries<N>> {
    private static final long serialVersionUID = 1L;
    private transient CalendarDateUnit myResolution = null;

    public CoordinationSet() {
    }

    public CoordinationSet(CalendarDateUnit resolution) {
        this.myResolution = resolution;
    }

    public CoordinationSet(Collection<CalendarDateSeries<N>> seriesCollection) {
        super(seriesCollection.size());
        for (CalendarDateSeries<N> tmpTimeSeries : seriesCollection) {
            this.put(tmpTimeSeries);
        }
    }

    public CoordinationSet(Collection<CalendarDateSeries<N>> seriesCollection, CalendarDateUnit resolution) {
        super(seriesCollection.size());
        this.myResolution = resolution;
        for (CalendarDateSeries<N> tmpTimeSeries : seriesCollection) {
            this.put(tmpTimeSeries);
        }
    }

    public CoordinationSet(int initialCapacity) {
        super(initialCapacity);
    }

    public CoordinationSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CoordinationSet(Map<? extends String, ? extends CalendarDateSeries<N>> members) {
        super(members);
    }

    public void complete() {
        for (CalendarDateSeries tmpSeries : this.values()) {
            tmpSeries.complete();
        }
    }

    public CoordinationSet<N> copy() {
        return this.resample(this.getResolution());
    }

    @Override
    public CalendarDateSeries<N> get(Object key) {
        if (key instanceof CalendarDateSeries) {
            return (CalendarDateSeries)super.get(((CalendarDateSeries)key).getName());
        }
        return (CalendarDateSeries)super.get(key.toString());
    }

    public CalendarDateSeries<N> get(String seriesName) {
        return (CalendarDateSeries)super.get(seriesName);
    }

    public List<CalendarDate> getAllCalendarDates() {
        TreeSet retVal = new TreeSet();
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.addAll(tmpSeries.keySet());
        }
        return new ArrayList<CalendarDate>(retVal);
    }

    public List<String> getAllSeriesNames() {
        return new ArrayList<String>(this.keySet());
    }

    public CalendarDate getEarliestFirstKey() {
        return (CalendarDate)BasicSeries.findEarliestFirstKey(this.values());
    }

    public CalendarDate getEarliestLastKey() {
        return (CalendarDate)BasicSeries.findEarliestLastKey(this.values());
    }

    public CalendarDate getLatestFirstKey() {
        return (CalendarDate)BasicSeries.findLatestFirstKey(this.values());
    }

    public CalendarDate getLatestLastKey() {
        return (CalendarDate)BasicSeries.findLatestLastKey(this.values());
    }

    public CalendarDateUnit getResolution() {
        if (this.myResolution == null) {
            CalendarDateUnit tmpRes = null;
            for (CalendarDateSeries series : this.values()) {
                tmpRes = series.getResolution();
                if (this.myResolution != null && tmpRes.compareTo(this.myResolution) <= 0) continue;
                this.myResolution = tmpRes;
            }
        }
        return this.myResolution;
    }

    public N getValue(String series, CalendarDate date) {
        return this.get(series).get(date);
    }

    public CoordinationSet<N> prune() {
        return this.doPruneAndResample(this.getLatestFirstKey(), this.getEarliestLastKey(), this.getResolution());
    }

    public CoordinationSet<N> prune(CalendarDateUnit resolution) {
        return this.doPruneAndResample(this.getLatestFirstKey(), this.getEarliestLastKey(), resolution);
    }

    public CalendarDateSeries<N> put(CalendarDateSeries<N> series) {
        return this.put(series.getName(), series);
    }

    public CoordinationSet<N> resample(CalendarDateUnit resolution) {
        return this.doPruneAndResample(this.getEarliestFirstKey(), this.getLatestLastKey(), resolution);
    }

    @Override
    public String toString() {
        StringBuilder retVal = new StringBuilder(this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
        for (CalendarDateSeries tmpSeries : this.values()) {
            retVal.append('\n');
            retVal.append(tmpSeries.toString());
        }
        return retVal.toString();
    }

    private CoordinationSet<N> doPruneAndResample(CalendarDate firstKey, CalendarDate lastKey, CalendarDateUnit resolution) {
        CoordinationSet<N> retVal = new CoordinationSet<N>();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            CalendarDateSeries value = (CalendarDateSeries)entry.getValue();
            CalendarDateSeries pruned = value.subMap(firstKey, true, lastKey, true);
            CalendarDateSeries resampled = (CalendarDateSeries)pruned.resample(resolution::adjustInto);
            retVal.put(key, resampled);
        }
        return retVal;
    }
}

