/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import org.ojalgo.data.DataProcessors;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;

public class SeriesSet {
    private final PrimitiveSeries[] mySet;

    SeriesSet(PrimitiveSeries[] set) {
        this.mySet = set;
    }

    public SeriesSet differences() {
        PrimitiveSeries[] retSet = new PrimitiveSeries[this.mySet.length];
        for (int i = 0; i < retSet.length; ++i) {
            retSet[i] = this.mySet[i].differences();
        }
        return new SeriesSet(retSet);
    }

    public <M extends Mutate2D> M getCorrelations(Factory2D<M> factory) {
        return DataProcessors.correlations(factory, this.mySet);
    }

    public <M extends Mutate2D> M getCovariances(Factory2D<M> factory) {
        return DataProcessors.covariances(factory, this.mySet);
    }

    public <M extends Structure2D> M getData(Factory2D.Dense<M> factory) {
        return factory.columns(this.mySet);
    }

    public SeriesSet log() {
        PrimitiveSeries[] retSet = new PrimitiveSeries[this.mySet.length];
        for (int i = 0; i < retSet.length; ++i) {
            retSet[i] = this.mySet[i].log();
        }
        return new SeriesSet(retSet);
    }

    public SeriesSet quotients() {
        PrimitiveSeries[] retSet = new PrimitiveSeries[this.mySet.length];
        for (int i = 0; i < retSet.length; ++i) {
            retSet[i] = this.mySet[i].quotients();
        }
        return new SeriesSet(retSet);
    }
}

