/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.function.Consumer;
import java.util.function.Function;
import org.ojalgo.type.function.AutoConsumer;

final class MappedConsumer<IN, OUT>
implements AutoConsumer<IN> {
    private final Consumer<OUT> myConsumer;
    private final Function<IN, OUT> myMapper;

    MappedConsumer(Function<IN, OUT> mapper, Consumer<OUT> consumer) {
        this.myMapper = mapper;
        this.myConsumer = consumer;
    }

    @Override
    public void close() throws Exception {
        if (this.myConsumer instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.myConsumer)).close();
        }
    }

    @Override
    public void write(IN item) {
        this.myConsumer.accept(this.myMapper.apply(item));
    }
}

