/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.client;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.io.writer.MzDBWriter;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.Spectrum;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbWriterApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MzdbWriterApi.class);
    private MzDBWriter m_writer = null;

    public String initializeMzdb(String path, AcquisitionMode srcAcqMode) {
        try {
            boolean isDIA = srcAcqMode != null && srcAcqMode.equals(AcquisitionMode.SWATH);
            File finalDbFile = new File(path);
            BBSizes defaultBBsize = new BBSizes(5.0, 10000.0, 15.0f, 0.0f);
            this.m_writer = new MzDBWriter(finalDbFile, true, null, defaultBBsize, isDIA);
            this.m_writer.initialize();
        }
        catch (Exception e) {
            LOGGER.error("error in initializeMzdb", (Throwable)e);
            return "KO:" + e.getMessage();
        }
        return "OK";
    }

    public String addMzdbMetaData(MzDBMetaData mzDbMetaData) {
        try {
            this.m_writer.addMetaData(mzDbMetaData);
        }
        catch (Exception e) {
            LOGGER.error("error in addMzdbMetaData", (Throwable)e);
            return "KO:" + e.getMessage();
        }
        return "OK";
    }

    public String addspectrum(Spectrum spectrum, DataEncoding dataEncoding) throws IOException, SQLiteException {
        try {
            this.m_writer.insertSpectrum(spectrum, dataEncoding);
        }
        catch (Exception e) {
            LOGGER.error("error in addspectrum", (Throwable)e);
            return "KO:" + e.getMessage();
        }
        return "OK";
    }

    public String closedb() {
        if (this.m_writer != null) {
            this.m_writer.close();
            return "OK";
        }
        LOGGER.error("error in closedb");
        return "KO";
    }
}

