/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model;

import fr.profi.mzdb.db.model.AbstractTableModel;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.Date;

public class Run
extends AbstractTableModel {
    public static final String TABLE_NAME = "run";
    protected String name;
    protected Date startTimestamp;
    protected Integer sampleId;
    protected Integer instrumentConfigId;
    protected Integer sourceFileId;

    public Run(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public Run(int id, String name, Date startTimestamp, ParamTree paramTree) {
        super(id, paramTree);
        this.name = name;
        this.startTimestamp = startTimestamp;
    }

    public Run(int id, String name, Date startTimestamp) {
        this(id, name, startTimestamp, null);
    }

    public String getName() {
        return this.name;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Integer getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(Integer sampleId) {
        this.sampleId = sampleId;
    }

    public Integer getInstrumentConfigId() {
        return this.instrumentConfigId;
    }

    public void setInstrumentConfigId(Integer instrumentConfigId) {
        this.instrumentConfigId = instrumentConfigId;
    }

    public Integer getSourceFileId() {
        return this.sourceFileId;
    }

    public void setSourceFileId(Integer sourceFileId) {
        this.sourceFileId = sourceFileId;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeString(this.name);
        writer.writeInt64(this.startTimestamp.getTime());
        writer.writeInt32(this.sampleId != null ? this.sampleId : -1);
        writer.writeInt32(this.instrumentConfigId != null ? this.instrumentConfigId : -1);
        writer.writeInt32(this.sourceFileId != null ? this.sourceFileId : -1);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readString();
        this.startTimestamp = new Date(reader.readInt64());
        this.sampleId = reader.readInt32();
        if (this.sampleId == -1) {
            this.sampleId = null;
        }
        this.instrumentConfigId = reader.readInt32();
        if (this.instrumentConfigId == -1) {
            this.instrumentConfigId = null;
        }
        this.sourceFileId = reader.readInt32();
        if (this.sourceFileId == -1) {
            this.sourceFileId = null;
        }
    }
}

