/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model;

import fr.profi.mzdb.db.model.params.ReferencableParamGroup;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import fr.profi.mzdb.util.misc.AbstractInMemoryIdGen;
import java.io.IOException;

public class SharedParamTree
extends AbstractInMemoryIdGen
implements SerializationInterface {
    public static final String TABLE_NAME = "shared_param_tree";
    protected long id;
    protected ReferencableParamGroup data;
    protected String schemaName;

    public SharedParamTree(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public SharedParamTree(long id, ReferencableParamGroup data, String schemaName) {
        this.id = id;
        this.data = data;
        this.schemaName = schemaName;
    }

    public SharedParamTree() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ReferencableParamGroup getData() {
        return this.data;
    }

    public void setData(ReferencableParamGroup data) {
        this.data = data;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        writer.writeInt64(this.id);
        boolean hasData = this.data != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.data.write(writer);
        }
        hasData = this.schemaName != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeString(this.schemaName);
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        this.id = reader.readInt64();
        boolean hasData = reader.readBoolean();
        this.data = hasData ? new ReferencableParamGroup(reader) : null;
        hasData = reader.readBoolean();
        this.schemaName = hasData ? reader.readString() : null;
    }
}

