/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.db.model.params.AnalyzerComponent;
import fr.profi.mzdb.db.model.params.Component;
import fr.profi.mzdb.db.model.params.DetectorComponent;
import fr.profi.mzdb.db.model.params.SourceComponent;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;

@XmlRootElement(name="componentList")
public class ComponentList
extends AbstractXMLParamTree {
    protected List<Component> components;
    protected int count;

    public ComponentList(int c) {
        this.count = c;
    }

    public ComponentList() {
    }

    public ComponentList(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    @XmlElements(value={@XmlElement(name="detector", required=true, type=DetectorComponent.class), @XmlElement(name="analyzer", required=true, type=AnalyzerComponent.class), @XmlElement(name="source", required=true, type=SourceComponent.class)})
    public List<Component> getComponents() {
        return this.components;
    }

    @XmlAttribute(required=true)
    @XmlSchemaType(name="nonNegativeInteger")
    public int getCount() {
        return this.count;
    }

    public void setCount(int c) {
        this.count = c;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        boolean hasData = this.components != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeInt32(this.components.size());
            for (Component component : this.components) {
                writer.writeInt32(component.getType().getTypeValue());
                component.write(writer);
            }
        }
        writer.writeInt32(this.count);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        boolean hasData = reader.readBoolean();
        if (hasData) {
            int size = reader.readInt32();
            this.components = new ArrayList<Component>(size);
            for (int i = 0; i < size; ++i) {
                Component element = null;
                int typeInt = reader.readInt32();
                Component.ComponentType componentType = Component.ComponentType.getEnum(typeInt);
                switch (componentType) {
                    case DETECTOR: {
                        element = new DetectorComponent(reader);
                        break;
                    }
                    case ANALYZER: {
                        element = new AnalyzerComponent(reader);
                        break;
                    }
                    case SOURCE: {
                        element = new SourceComponent(reader);
                    }
                }
                this.components.add(element);
            }
        } else {
            this.components = null;
        }
        this.count = reader.readInt32();
    }
}

