/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.Activation;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.SelectedIon;
import fr.profi.mzdb.db.model.params.SelectedIonList;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="precursor")
public class Precursor
implements SerializationInterface {
    protected String spectrumRef;
    protected IsolationWindowParamTree isolationWindow;
    protected SelectedIonList selectedIonList;
    protected Activation activation;

    public Precursor() {
    }

    public Precursor(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public void setSpectrumRef(String spectrumRef) {
        this.spectrumRef = spectrumRef;
    }

    @XmlAttribute(required=true)
    public String getSpectrumRef() {
        return this.spectrumRef;
    }

    @XmlElement(name="isolationWindow")
    public IsolationWindowParamTree getIsolationWindow() {
        return this.isolationWindow;
    }

    @XmlElement(name="activation")
    public Activation getActivation() {
        return this.activation;
    }

    @XmlElement(name="selectedIonList")
    public SelectedIonList getSelectedIonList() {
        return this.selectedIonList;
    }

    public double parseFirstSelectedIonMz() {
        SelectedIonList sil = this.getSelectedIonList();
        SelectedIon si = sil.getSelectedIons().get(0);
        String precMzAsStr = si.getCVParam(CVEntry.SELECTED_ION_MZ).getValue();
        return Double.parseDouble(precMzAsStr);
    }

    public void setIsolationWindow(IsolationWindowParamTree isolationWindow) {
        this.isolationWindow = isolationWindow;
    }

    public void setSelectedIonList(SelectedIonList selectedIonList) {
        this.selectedIonList = selectedIonList;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        boolean hasData = this.spectrumRef != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeString(this.spectrumRef);
        }
        hasData = this.isolationWindow != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.isolationWindow.write(writer);
        }
        hasData = this.selectedIonList != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.selectedIonList.write(writer);
        }
        hasData = this.activation != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.activation.write(writer);
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        boolean hasData = reader.readBoolean();
        this.spectrumRef = hasData ? reader.readString() : null;
        hasData = reader.readBoolean();
        this.isolationWindow = hasData ? new IsolationWindowParamTree(reader) : null;
        hasData = reader.readBoolean();
        this.selectedIonList = hasData ? new SelectedIonList(reader) : null;
        hasData = reader.readBoolean();
        this.activation = hasData ? new Activation(reader) : null;
    }
}

