/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.db.model.params.ScanWindowList;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.thermo.ThermoScanMetaData;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementWrapper;

public class ScanParamTree
extends AbstractXMLParamTree {
    @XmlElementWrapper
    protected List<ScanWindowList> scanWindowList;

    public List<ScanWindowList> getScanWindowList() {
        return this.scanWindowList;
    }

    public ScanParamTree() {
    }

    public ScanParamTree(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public ThermoScanMetaData getThermoMetaData() {
        CVParam filterStringCvParam = this.getCVParam(CVEntry.FILTER_STRING);
        if (filterStringCvParam == null) {
            return null;
        }
        return new ThermoScanMetaData(filterStringCvParam.getValue());
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        boolean hasData = this.scanWindowList != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeInt32(this.scanWindowList.size());
            for (SerializationInterface serializationInterface : this.scanWindowList) {
                serializationInterface.write(writer);
            }
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        boolean hasData = reader.readBoolean();
        if (hasData) {
            int size = reader.readInt32();
            this.scanWindowList = new ArrayList<ScanWindowList>(size);
            for (int i = 0; i < size; ++i) {
                ScanWindowList element = new ScanWindowList(reader);
                this.scanWindowList.add(element);
            }
        } else {
            this.scanWindowList = null;
        }
    }
}

