/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.bb;

import com.almworks.sqlite4java.SQLiteBlob;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.io.reader.bb.AbstractBlobReader;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.primitives.BytesUtils;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class SQLiteBlobReader
extends AbstractBlobReader {
    protected SQLiteBlob _blob;

    public SQLiteBlobReader(SQLiteBlob blob, long firstSpectrumId, long lastSpectrumId, Map<Long, SpectrumHeader> spectrumHeaderById, Map<Long, DataEncoding> dataEncodingBySpectrumId) throws StreamCorruptedException {
        super(firstSpectrumId, lastSpectrumId, spectrumHeaderById, dataEncodingBySpectrumId);
        this._blob = blob;
        this._indexSpectrumSlices((int)(1L + lastSpectrumId - firstSpectrumId));
    }

    @Override
    public void disposeBlob() {
        this._blob.dispose();
    }

    public int getBlobSize() {
        try {
            return this._blob.getSize();
        }
        catch (SQLiteException e) {
            this.logger.error("can't get SQLiteBlob size", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int getSpectraCount() {
        return this._spectraCount;
    }

    protected void _indexSpectrumSlices(int estimatedSpectraCount) throws StreamCorruptedException {
        int[] spectrumSliceStartPositions = new int[estimatedSpectraCount];
        int[] peaksCounts = new int[estimatedSpectraCount];
        int size = this.getBlobSize();
        int spectrumSliceIdx = 0;
        int byteIdx = 0;
        while (byteIdx < size) {
            int peaksCount;
            long spectrumId = this._getIntFromBlob(this._blob, byteIdx);
            this._spectrumSliceStartPositions[spectrumSliceIdx] = byteIdx;
            this._peaksCounts[spectrumSliceIdx] = peaksCount = this._getIntFromBlob(this._blob, byteIdx += 4);
            byteIdx += 4;
            DataEncoding de = (DataEncoding)this._dataEncodingBySpectrumId.get(spectrumId);
            this.checkDataEncodingIsNotNull(de, spectrumId);
            byteIdx += peaksCount * de.getPeakStructSize();
            ++spectrumSliceIdx;
        }
        this._spectraCount = spectrumSliceIdx;
        this._spectrumSliceStartPositions = Arrays.copyOf(spectrumSliceStartPositions, this._spectraCount);
        this._peaksCounts = Arrays.copyOf(peaksCounts, this._spectraCount);
    }

    @Override
    public long getSpectrumIdAt(int idx) {
        this.checkSpectrumIndexRange(idx);
        return this._getSpectrumIdAt(idx);
    }

    private long _getSpectrumIdAt(int idx) {
        return this._getIntFromBlob(this._blob, idx);
    }

    private int _getIntFromBlob(SQLiteBlob blob, int idx) {
        byte[] byteBuffer = new byte[4];
        try {
            blob.read(idx, byteBuffer, 0, 4);
        }
        catch (SQLiteException e) {
            this.logger.error("can't read bytes from the SQLiteBlob", (Throwable)e);
        }
        return BytesUtils.bytesToInt(byteBuffer, 0);
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx) {
        long spectrumId = this._getSpectrumIdAt(idx);
        SpectrumData spectrumSliceData = this._readFilteredSpectrumSliceDataAt(idx, spectrumId, -1.0, -1.0);
        SpectrumHeader sh = (SpectrumHeader)this._spectrumHeaderById.get(spectrumId);
        return new SpectrumSlice(sh, spectrumSliceData);
    }

    @Override
    public SpectrumData readSpectrumSliceDataAt(int idx) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), -1.0, -1.0);
    }

    @Override
    public SpectrumData readFilteredSpectrumSliceDataAt(int idx, double minMz, double maxMz) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), minMz, maxMz);
    }

    private SpectrumData _readFilteredSpectrumSliceDataAt(int idx, long spectrumId, double minMz, double maxMz) {
        DataEncoding de = (DataEncoding)this._dataEncodingBySpectrumId.get(spectrumId);
        int peaksBytesSize = this._peaksCounts[idx] * de.getPeakStructSize();
        int spectrumSliceStartPos = this._spectrumSliceStartPositions[idx] + 8;
        byte[] peaksBytes = new byte[peaksBytesSize];
        try {
            this._blob.read(spectrumSliceStartPos, peaksBytes, 0, peaksBytesSize);
        }
        catch (SQLiteException e) {
            this.logger.error("can't read bytes from the SQLiteBlob", (Throwable)e);
        }
        return this.readSpectrumSliceData(ByteBuffer.wrap(peaksBytes), spectrumSliceStartPos, peaksBytesSize, de, minMz, maxMz);
    }
}

