/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.cache;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbAsyncReader;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.AbstractSpectrumHeaderReader;
import fr.profi.mzdb.model.SpectrumHeader;
import java.util.Map;
import rx.Observable;

public class SpectrumHeaderAsyncReader
extends AbstractSpectrumHeaderReader {
    private MzDbAsyncReader mzDbReader = null;

    public SpectrumHeaderAsyncReader(MzDbAsyncReader mzDbReader, AbstractDataEncodingReader dataEncodingReader) throws SQLiteException {
        super(mzDbReader, dataEncodingReader);
        this.mzDbReader = mzDbReader;
    }

    @Override
    public MzDbAsyncReader getMzDbReader() {
        return this.mzDbReader;
    }

    public Observable<SpectrumHeader[]> getSpectrumHeaders() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getSpectrumHeaders(connection));
    }

    public Observable<Map<Long, SpectrumHeader>> getSpectrumHeaderById() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getSpectrumHeaderById(connection));
    }

    public Observable<SpectrumHeader[]> getMs1SpectrumHeaders() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getMs1SpectrumHeaders(connection));
    }

    public Observable<Map<Long, SpectrumHeader>> getMs1SpectrumHeaderById() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getMs1SpectrumHeaderById(connection));
    }

    public Observable<SpectrumHeader[]> getMs2SpectrumHeaders() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getMs2SpectrumHeaders(connection));
    }

    public Observable<Map<Long, SpectrumHeader>> getMs2SpectrumHeaderById() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getMs2SpectrumHeaderById(connection));
    }

    public Observable<SpectrumHeader> getSpectrumHeader(long id) {
        return this.getMzDbReader().observeJobExecution(connection -> this.getSpectrumHeader(id, connection));
    }

    public Observable<Map<Long, Float>> getSpectrumTimeById() {
        return this.getMzDbReader().observeJobExecution(connection -> this.getSpectrumTimeById(connection));
    }

    public Observable<SpectrumHeader> getSpectrumHeaderForTime(float time, int msLevel) {
        return this.getMzDbReader().observeJobExecution(connection -> this.getSpectrumHeaderForTime(time, msLevel, connection));
    }

    public Observable<long[]> getSpectrumIdsForTimeRange(float minRT, float maxRT, int msLevel) {
        return this.getMzDbReader().observeJobExecution(connection -> this.getSpectrumIdsForTimeRange(minRT, maxRT, msLevel, connection));
    }
}

