/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.iterator;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.AbstractRunSliceHeaderReader;
import fr.profi.mzdb.io.reader.cache.AbstractSpectrumHeaderReader;
import fr.profi.mzdb.io.reader.iterator.AbstractSpectrumSliceIterator;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.model.RunSliceData;
import fr.profi.mzdb.model.RunSliceHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.sqlite.ISQLiteStatementConsumer;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractRunSliceIterator
extends AbstractSpectrumSliceIterator
implements Iterator<RunSlice> {
    protected SpectrumSlice[] spectrumSliceBuffer = null;
    protected boolean bbHasNext = true;
    protected final HashMap<Integer, RunSliceHeader> runSliceHeaderById;

    public AbstractRunSliceIterator(AbstractRunSliceHeaderReader runSliceHeaderReader, AbstractSpectrumHeaderReader spectrumHeaderReader, AbstractDataEncodingReader dataEncodingReader, SQLiteConnection connection, String sqlQuery, int msLevel, ISQLiteStatementConsumer stmtBinder) throws SQLiteException, StreamCorruptedException {
        super(spectrumHeaderReader, dataEncodingReader, connection, sqlQuery, msLevel, stmtBinder);
        this.runSliceHeaderById = runSliceHeaderReader.getRunSliceHeaderById(msLevel, connection);
    }

    protected void initSpectrumSliceBuffer() {
        this.spectrumSliceBuffer = this.firstBB.toSpectrumSlices();
        ArrayList<SpectrumSlice> sl = new ArrayList<SpectrumSlice>(Arrays.asList(this.spectrumSliceBuffer));
        while (this.bbHasNext = this.boundingBoxIterator.hasNext()) {
            BoundingBox bb = (BoundingBox)this.boundingBoxIterator.next();
            if (bb.getRunSliceId() == this.firstBB.getRunSliceId()) {
                sl.addAll(Arrays.asList(bb.toSpectrumSlices()));
                continue;
            }
            this.firstBB = bb;
            break;
        }
        this.spectrumSliceBuffer = sl.toArray(new SpectrumSlice[sl.size()]);
        if (!this.bbHasNext) {
            this.firstBB = null;
        }
    }

    @Override
    public RunSlice next() {
        this.initSpectrumSliceBuffer();
        int runSliceId = this.spectrumSliceBuffer[0].getRunSliceId();
        RunSliceData rsd = new RunSliceData(runSliceId, this.spectrumSliceBuffer);
        RunSliceHeader rsh = this.runSliceHeaderById.get(runSliceId);
        return new RunSlice(rsh, rsd);
    }
}

