/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import java.util.List;

public abstract class AbstractTableModelReader<T> {
    protected SQLiteConnection connection;
    protected ISQLiteRecordExtraction<T> recordExtractor;

    protected AbstractTableModelReader(SQLiteConnection connection) {
        this.connection = connection;
        this.recordExtractor = this.buildRecordExtractor();
    }

    protected abstract ISQLiteRecordExtraction<T> buildRecordExtractor();

    protected T getRecord(String tableName, int id) throws SQLiteException {
        return new SQLiteQuery(this.connection, "SELECT * FROM " + tableName + " WHERE id = ?").bind(1, id).extractRecord(this.recordExtractor);
    }

    protected List<T> getRecordList(String tableName) throws SQLiteException {
        return new SQLiteQuery(this.connection, "SELECT * FROM " + tableName).extractRecordList(this.recordExtractor);
    }
}

