/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer;

import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.model.RunSliceHeader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class RunSliceStructureFactory {
    private final BBSizes bbSizes;
    private final int maxMS1SlicesHint;
    private HashMap<RunSliceKey, RunSliceHeader> runSlicesStructure = new HashMap();
    private HashMap<Integer, RunSliceHeader> runSliceById = new HashMap();
    private final int runId;
    private RunSliceKey _key = new RunSliceKey();

    public RunSliceStructureFactory(Integer runId, int maxMS1SlicesHint, BBSizes bbSizes) {
        this.runId = runId;
        this.bbSizes = bbSizes;
        this.maxMS1SlicesHint = maxMS1SlicesHint;
    }

    public RunSliceHeader addRunSlice(Integer msLevel, Float beginMz, Float endMz) {
        int offset = msLevel == 1 ? 1 : this.maxMS1SlicesHint * (msLevel - 1) + 1;
        int runSliceId = (int)Math.floor((double)beginMz.floatValue() / this.bbSizes.BB_MZ_HEIGHT_MS1) + offset;
        RunSliceHeader runSlice = new RunSliceHeader(runSliceId, msLevel, -1, beginMz.floatValue(), endMz.floatValue(), this.runId);
        RunSliceKey key = new RunSliceKey(msLevel, beginMz, endMz);
        this.runSlicesStructure.put(key, runSlice);
        this.runSliceById.put(runSlice.getId(), runSlice);
        return runSlice;
    }

    public boolean hasRunSlice(Integer msLevel, Float beginMz, Float endMz) {
        this._key.msLevel = msLevel;
        this._key.beginMz = beginMz;
        this._key.endMz = endMz;
        return this.hasRunSlice(this._key);
    }

    public boolean hasRunSlice(RunSliceKey key) {
        return this.runSlicesStructure.containsKey(key);
    }

    public Integer getRunSliceId(Integer msLevel, Float beginMz, Float endMz) {
        this._key.msLevel = msLevel;
        this._key.beginMz = beginMz;
        this._key.endMz = endMz;
        if (this.hasRunSlice(this._key)) {
            return this.runSlicesStructure.get(this._key).getId();
        }
        return null;
    }

    public RunSliceHeader getRunSlice(Integer id) {
        return this.runSliceById.get(id);
    }

    public List<RunSliceHeader> getAllRunSlices() {
        Comparator<RunSliceHeader> comparator = new Comparator<RunSliceHeader>(){

            @Override
            public int compare(RunSliceHeader rsh1, RunSliceHeader rsh2) {
                if (rsh1.getMsLevel() < rsh2.getMsLevel()) {
                    return -1;
                }
                if (rsh1.getMsLevel() > rsh2.getMsLevel()) {
                    return 1;
                }
                return rsh1.getId() - rsh2.getId();
            }
        };
        ArrayList<RunSliceHeader> headers = new ArrayList<RunSliceHeader>(this.runSlicesStructure.values());
        headers.sort(comparator);
        for (int i = 0; i < headers.size(); ++i) {
            ((RunSliceHeader)headers.get(i)).setNumber(i + 1);
        }
        return headers;
    }

    public Integer getRunSlicesCount() {
        return this.runSliceById.size();
    }

    private class RunSliceKey {
        Integer msLevel;
        Float beginMz;
        Float endMz;

        public RunSliceKey() {
        }

        public RunSliceKey(Integer msL, Float beginMz, Float endMz) {
            this.msLevel = msL;
            this.beginMz = beginMz;
            this.endMz = endMz;
        }

        public Integer getMsLevel() {
            return this.msLevel;
        }

        public Float getBeginMz() {
            return this.beginMz;
        }

        public Float getEndMz() {
            return this.endMz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunSliceKey that = (RunSliceKey)o;
            return Objects.equals(this.getMsLevel(), that.getMsLevel()) && Objects.equals(this.getBeginMz(), that.getBeginMz()) && Objects.equals(this.getEndMz(), that.getEndMz());
        }

        public int hashCode() {
            return Objects.hash(this.getMsLevel(), this.getBeginMz(), this.getEndMz());
        }
    }
}

