/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.HashMap;

public enum AcquisitionMode implements SerializationInterface
{
    DDA("DDA acquisition", "Data Dependant Acquisition (Thermo designation), Warning: in ABI this is called IDA (Information Dependant Acquisition)"),
    DIA("SRM acquisition", "Single reaction monitoring"),
    SWATH("SWATH acquisition", "ABI Swath acquisition or Thermo swath acquisition"),
    PRM("PRM acquisition", "Parallel reaction monitoring"),
    MRM("MRM acquisition", "Multiple reaction monitoring"),
    SRM("SRM acquisition", "Single reaction monitoring"),
    UNKNOWN("UNKNOWN acquisition", "unknown acquisition mode");

    private static HashMap<String, AcquisitionMode> map;
    private String description;
    private String code;

    private AcquisitionMode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.code;
    }

    public boolean isDataIndependantAcquisition() {
        return this == DIA || this == SWATH || this == PRM || this == MRM || this == SRM;
    }

    public static AcquisitionMode getAcquisitionMode(String code) {
        AcquisitionMode val = map.get(code);
        return val != null ? val : UNKNOWN;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        writer.writeString(this.code);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        throw new IOException("read is not allowed for Enums");
    }

    public static AcquisitionMode getEnum(SerializationReader reader) throws IOException {
        String key = reader.readString();
        return map.get(key);
    }

    static {
        map = new HashMap();
        for (AcquisitionMode valEnum : AcquisitionMode.values()) {
            map.put(valEnum.code, valEnum);
        }
    }
}

