/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.SpectrumHeader;
import java.util.Comparator;

public class Peak
implements Cloneable,
Comparable<Peak> {
    protected final double mz;
    protected float intensity;
    protected final float leftHwhm;
    protected final float rightHwhm;
    private float _nf = -1.0f;
    protected ILcContext lcContext;
    public static Comparator<Peak> intensityComp = new Comparator<Peak>(){

        @Override
        public int compare(Peak peak0, Peak peak1) {
            if (peak0.intensity < peak1.intensity) {
                return -1;
            }
            if ((double)Math.abs(peak0.intensity - peak1.intensity) < 1.0E-6) {
                return 0;
            }
            return 1;
        }
    };

    public Peak(double mz, float intensity, float leftHwhm, float rightHwhm, ILcContext lcContext) {
        this.mz = mz;
        this.intensity = intensity;
        this.leftHwhm = leftHwhm;
        this.rightHwhm = rightHwhm;
        this.lcContext = lcContext;
    }

    public Peak(double mz, float intensity) {
        this(mz, intensity, 0.0f, 0.0f, null);
    }

    public double getMz() {
        return this.mz;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getLeftHwhm() {
        return this.leftHwhm;
    }

    public float getRightHwhm() {
        return this.rightHwhm;
    }

    public ILcContext getLcContext() {
        return this.lcContext;
    }

    public void setLcContext(ILcContext lcContext) {
        this.lcContext = lcContext;
    }

    public SpectrumHeader getSpectrumHeader() throws ClassCastException {
        return (SpectrumHeader)this.lcContext;
    }

    public boolean isNormalized() {
        return this._nf > 0.0f;
    }

    public void normalizeIntensity(float nf) throws Exception {
        if (nf < 0.0f) {
            throw new IllegalArgumentException("nf can't be negative");
        }
        if (this._nf > 0.0f) {
            throw new Exception("peak intensity has been already normalized");
        }
        this._nf = nf;
        this.intensity *= nf;
    }

    protected Peak clone() {
        return new Peak(this.mz, this.intensity, this.leftHwhm, this.rightHwhm, this.lcContext);
    }

    public String toString() {
        return String.format("Peak@ %.4f;%.1f", this.mz, Float.valueOf(this.intensity));
    }

    public static Comparator<Peak> getIntensityComp() {
        return intensityComp;
    }

    @Override
    public int compareTo(Peak aPeak) {
        if (this.mz < aPeak.mz) {
            return -1;
        }
        if (Math.abs(this.mz - aPeak.mz) < Double.MIN_VALUE) {
            return 0;
        }
        return 1;
    }
}

