/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.serialization;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class SerializationReader {
    private CodedInputStream codedInput;

    public SerializationReader(InputStream inputStream) {
        this.codedInput = CodedInputStream.newInstance((InputStream)inputStream);
    }

    public void resetStream() {
        this.codedInput.resetSizeCounter();
    }

    public String readString() throws IOException {
        String value = this.codedInput.readStringRequireUtf8();
        return value;
    }

    public int readInt32() throws IOException {
        return this.codedInput.readInt32();
    }

    public long readInt64() throws IOException {
        return this.codedInput.readInt64();
    }

    public float readFloat() throws IOException {
        return this.codedInput.readFloat();
    }

    public double readDouble() throws IOException {
        return this.codedInput.readDouble();
    }

    public boolean readBoolean() throws IOException {
        return this.codedInput.readBool();
    }

    public String[] readArrayString() throws IOException {
        int size = this.codedInput.readInt32();
        String[] array = new String[size];
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            array[i] = this.codedInput.readStringRequireUtf8();
            ++i;
        }
        this.codedInput.popLimit(limit);
        return array;
    }

    public int[] readArrayInt32() throws IOException {
        int size = this.codedInput.readInt32();
        int[] array = new int[size];
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            array[i] = this.codedInput.readInt32();
            ++i;
        }
        this.codedInput.popLimit(limit);
        return array;
    }

    public long[] readArrayInt64() throws IOException {
        int size = this.codedInput.readInt32();
        long[] array = new long[size];
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            array[i] = this.codedInput.readInt64();
            ++i;
        }
        this.codedInput.popLimit(limit);
        return array;
    }

    public float[] readArrayFloat() throws IOException {
        int size = this.codedInput.readInt32();
        float[] array = new float[size];
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            array[i] = this.codedInput.readFloat();
            ++i;
        }
        this.codedInput.popLimit(limit);
        return array;
    }

    public double[] readArrayDouble() throws IOException {
        int size = this.codedInput.readInt32();
        double[] array = new double[size];
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            array[i] = this.codedInput.readDouble();
            ++i;
        }
        this.codedInput.popLimit(limit);
        return array;
    }

    public boolean[] readArrayBoolean() throws IOException {
        int size = this.codedInput.readInt32();
        boolean[] array = new boolean[size];
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            array[i] = this.codedInput.readBool();
            ++i;
        }
        this.codedInput.popLimit(limit);
        return array;
    }

    public HashMap<Integer, String> readMapIntString() throws IOException {
        int size = this.codedInput.readInt32();
        HashMap<Integer, String> map = new HashMap<Integer, String>(size);
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            int key = this.codedInput.readInt32();
            String value = this.codedInput.readStringRequireUtf8();
            map.put(key, value);
            ++i;
        }
        this.codedInput.popLimit(limit);
        return map;
    }

    public HashMap<Integer, Double> readMapIntDouble() throws IOException {
        int size = this.codedInput.readInt32();
        HashMap<Integer, Double> map = new HashMap<Integer, Double>(size);
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            int key = this.codedInput.readInt32();
            Double value = this.codedInput.readDouble();
            map.put(key, value);
            ++i;
        }
        this.codedInput.popLimit(limit);
        return map;
    }

    public HashMap<String, String> readMapStringString() throws IOException {
        int size = this.codedInput.readInt32();
        HashMap<String, String> map = new HashMap<String, String>(size);
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            String key = this.codedInput.readStringRequireUtf8();
            String value = this.codedInput.readStringRequireUtf8();
            map.put(key, value);
            ++i;
        }
        this.codedInput.popLimit(limit);
        return map;
    }

    public HashMap<String, Integer> readMapStringInteger() throws IOException {
        int size = this.codedInput.readInt32();
        HashMap<String, Integer> map = new HashMap<String, Integer>(size);
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            String key = this.codedInput.readStringRequireUtf8();
            Integer value = this.codedInput.readInt32();
            map.put(key, value);
            ++i;
        }
        this.codedInput.popLimit(limit);
        return map;
    }

    public HashMap<String, Double> readMapStringDouble() throws IOException {
        int size = this.codedInput.readInt32();
        HashMap<String, Double> map = new HashMap<String, Double>(size);
        int length = this.codedInput.readRawVarint32();
        int limit = this.codedInput.pushLimit(length);
        int i = 0;
        while (this.codedInput.getBytesUntilLimit() > 0) {
            String key = this.codedInput.readStringRequireUtf8();
            Double value = this.codedInput.readDouble();
            map.put(key, value);
            ++i;
        }
        this.codedInput.popLimit(limit);
        return map;
    }
}

