/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.sqlite;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.Iterator;

public class SQLiteRecordIterator
implements Iterator<SQLiteRecord> {
    protected final SQLiteQuery query;
    protected SQLiteStatement stmt;
    protected SQLiteRecord nextRecord = null;
    protected boolean _hasNext = false;
    protected boolean _hasNextChecked = false;

    public boolean isStatementDisposed() {
        return this.stmt == null || this.stmt.isDisposed();
    }

    public SQLiteRecordIterator(SQLiteQuery query) throws SQLiteException {
        this.query = query;
        this.stmt = query.getStatement();
        this.nextRecord = null;
    }

    public void dispose() {
        if (!this.isStatementDisposed() && this.stmt != null) {
            this.stmt.dispose();
            this.stmt = null;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this._hasNextChecked) {
                this._hasNextChecked = true;
                if (this.stmt.step()) {
                    this._hasNext = true;
                } else {
                    this.dispose();
                    this._hasNext = false;
                }
            }
            return this._hasNext;
        }
        catch (SQLiteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public SQLiteRecord next() {
        try {
            if (this.hasNext()) {
                this.nextRecord = new SQLiteRecord(this.query);
                this._hasNextChecked = false;
                return this.nextRecord;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported Operation");
    }

    protected void rethrow(SQLiteException e) {
        throw new RuntimeException(e.getMessage());
    }
}

