/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map;

import fr.profi.mzdb.model.SpectrumSlice;
import fr.proline.mzscope.map.AbstractLcMsMapSpectrum;
import fr.proline.mzscope.map.LcMsMapChunk;

public class LcMsMapMzSpectrum
extends AbstractLcMsMapSpectrum {
    private double[] intensities = new double[this.getSliceCount()];
    private double maxIntensity = 0.0;

    public LcMsMapMzSpectrum(LcMsMapChunk chunk, double sliceSizeMz) {
        super(chunk.getViewport().minMz, chunk.getViewport().maxMz, sliceSizeMz);
        for (SpectrumSlice slice : chunk.getSlices()) {
            double rt = slice.getHeader().getElutionTime();
            if (rt < chunk.getViewport().minRt || rt > chunk.getViewport().maxRt) continue;
            for (int dataIndex = 0; dataIndex < slice.getData().getIntensityList().length; ++dataIndex) {
                double mz = slice.getData().getMzList()[dataIndex];
                double intensity = slice.getData().getIntensityList()[dataIndex];
                if (mz < chunk.getViewport().minMz || mz > chunk.getViewport().maxMz) continue;
                int mzIndex = this.getMzIndex(mz);
                if (mzIndex < 0 || mzIndex >= this.intensities.length) {
                    System.out.println("mz index " + mzIndex + " out of bounds " + this.intensities.length);
                    continue;
                }
                int n = mzIndex;
                this.intensities[n] = this.intensities[n] + intensity;
                this.maxIntensity = Math.max(this.maxIntensity, this.intensities[mzIndex]);
            }
        }
    }

    @Override
    public final double[] getIntensities() {
        return this.intensities;
    }

    @Override
    public final double getIntensity(int rtIndex) throws IndexOutOfBoundsException {
        return this.intensities[rtIndex];
    }

    @Override
    public final double getMaxIntensity() {
        return this.maxIntensity;
    }

    private int getMzIndex(double mz) {
        return (int)((mz - this.getMinX()) / this.getSliceSize());
    }

    @Override
    public int getIndex(double xValue) {
        return this.getMzIndex(xValue);
    }

    @Override
    public double getIntensity(double mz) {
        return this.intensities[this.getMzIndex(mz)];
    }
}

