/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map.control;

import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.control.AbstractLcMsViewerManipulator;
import fr.proline.mzscope.map.control.LcMsViewerController;
import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class LcMsViewerSelectionManipulator
extends AbstractLcMsViewerManipulator {
    private int clickX = -1;
    private int clickY = -1;
    private int currentX = -1;
    private int currentY = -1;
    private int clickWidth = -1;
    private int clickHeight = -1;
    private LcMsViewport clickViewport = null;
    private JToggleButton button = null;
    private Stroke selectionStroke = null;
    private ImageIcon selectIcon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.SELECT);

    public LcMsViewerSelectionManipulator(LcMsViewerController controller) {
        super(controller);
        this.selectionStroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f}, 0.0f);
    }

    @Override
    public JToggleButton getUIButton() {
        if (this.button == null) {
            this.button = new JToggleButton();
            this.button.setIcon(this.selectIcon);
        }
        return this.button;
    }

    @Override
    public void paintComponent(Graphics2D g) {
        if (this.isInteractive()) {
            g.setColor(Color.white);
            g.setStroke(this.selectionStroke);
            g.drawRect(this.clickX, this.clickY, this.currentX - this.clickX, this.currentY - this.clickY);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double wheel = e.getPreciseWheelRotation();
        double scale = 1.0 + wheel / 5.0;
        Point2D centerValues = this.getController().getUI().getDisplayViewport().pixel2value(e.getX(), e.getY(), this.getController().getUI().getCanvas().getWidth(), this.getController().getUI().getCanvas().getHeight());
        this.getController().getUI().setDisplayViewport(this.getController().getUI().getDisplayViewport().centerScale(centerValues.getX(), centerValues.getY(), scale, scale));
        this.getController().changeViewport(this.getController().getUI().getDisplayViewport());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.clickViewport = new LcMsViewport(this.getController().getUI().getDisplayViewport());
        this.clickX = e.getX();
        this.clickY = e.getY();
        this.clickWidth = this.getController().getUI().getCanvas().getWidth();
        this.clickHeight = this.getController().getUI().getCanvas().getHeight();
        this.setInteractive(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.clickViewport != null) {
            this.clickViewport = null;
            this.setInteractive(false);
            Point2D p1 = this.getController().pixel2values(this.clickX, this.clickY);
            Point2D p2 = this.getController().pixel2values(e.getX(), e.getY());
            LcMsViewport viewport = new LcMsViewport(Math.min(p1.getX(), p2.getX()), Math.max(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.max(p1.getY(), p2.getY()));
            this.getController().changeViewport(viewport);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.clickViewport != null) {
            this.currentX = e.getX();
            this.currentY = e.getY();
            this.getDrawingPanel().repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.getController().getUI().updateMouseInformationUI(e.getX(), e.getY());
    }
}

