/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.proline.mzscope.model.IChromatogram;
import java.util.Arrays;

public class Chromatogram
implements IChromatogram {
    private String rawFilename;
    private String title;
    private double minMz = -1.0;
    private double maxMz = -1.0;
    private double[] time;
    private double[] intensities;
    private double elutionStartTime = Double.NaN;
    private double elutionEndTime = Double.NaN;
    private double m_maxIntensity = Double.NaN;

    public Chromatogram(String rawFilename, String title, double[] time, double[] intensities) {
        this.rawFilename = rawFilename;
        this.title = title;
        this.time = time;
        this.intensities = intensities;
    }

    public Chromatogram(String rawFilename, String title, double[] time, double[] intensities, double start, double end) {
        this(rawFilename, title, time, intensities);
        this.elutionStartTime = start;
        this.elutionEndTime = end;
    }

    @Override
    public double getMaxIntensity() {
        if (Double.isNaN(this.m_maxIntensity)) {
            this.m_maxIntensity = Arrays.stream(this.getIntensities()).max().orElse(Double.NaN);
        }
        return this.m_maxIntensity;
    }

    @Override
    public String getRawFilename() {
        return this.rawFilename;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public double getMinMz() {
        return this.minMz;
    }

    @Override
    public double getMaxMz() {
        return this.maxMz;
    }

    @Override
    public double[] getTime() {
        return this.time;
    }

    @Override
    public double[] getIntensities() {
        return this.intensities;
    }

    @Override
    public double getElutionStartTime() {
        if (Double.isNaN(this.elutionStartTime)) {
            return this.time[0];
        }
        return this.elutionStartTime;
    }

    @Override
    public double getElutionEndTime() {
        if (Double.isNaN(this.elutionEndTime)) {
            return this.time[this.time.length - 1];
        }
        return this.elutionEndTime;
    }

    public void setMinMz(double minMz) {
        this.minMz = minMz;
    }

    public void setMaxMz(double maxMz) {
        this.maxMz = maxMz;
    }
}

