/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.mzdb.model.SpectrumHeader;
import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.BasePeakel;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.IsolationWindow;
import fr.proline.mzscope.processing.IAnnotator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromatogramAnnotator
implements IAnnotator {
    private static final Logger logger = LoggerFactory.getLogger(ChromatogramAnnotator.class);
    public static final double EPSILON_TIME = 0.01;

    @Override
    public AnnotatedChromatogram annotate(IRawFile rawFile, IChromatogram chromatogram, ExtractionRequest request, Integer expectedCharge) {
        try {
            if (chromatogram == null) {
                return null;
            }
            int maxConsecutiveGaps = 3;
            double[] globalTime = this.getElutionTimes(rawFile, request);
            double[] chromatogramIntensities = chromatogram.getIntensities();
            double[] chromatogramTime = chromatogram.getTime();
            int globalRtIndex = ~Arrays.binarySearch(globalTime, (double)request.getElutionTime());
            int chromatogramRtIndex = ~Arrays.binarySearch(chromatogramTime, (double)request.getElutionTime());
            int chromatogramIndex = chromatogramRtIndex = chromatogramRtIndex < chromatogramTime.length ? chromatogramRtIndex : chromatogramTime.length - 1;
            ArrayList<Integer> peakelIndexes = new ArrayList<Integer>(chromatogramTime.length);
            if (globalRtIndex != -1) {
                int k;
                int consecutiveGaps = 0;
                int cEndIdx = chromatogramIndex;
                int cStartIdx = chromatogramIndex;
                int startIdx = globalRtIndex;
                int endIdx = globalRtIndex;
                double maxIntensity = -1.0;
                for (k = globalRtIndex; k < globalTime.length && chromatogramIndex < chromatogramTime.length && consecutiveGaps <= 3; ++k) {
                    if (Math.abs(globalTime[k] - chromatogramTime[chromatogramIndex]) < 0.01) {
                        if (chromatogramIntensities[chromatogramIndex] > 0.0) {
                            consecutiveGaps = 0;
                            cEndIdx = chromatogramIndex;
                            endIdx = k;
                            maxIntensity = Math.max(maxIntensity, chromatogramIntensities[chromatogramIndex]);
                            peakelIndexes.add(chromatogramIndex);
                        } else {
                            ++consecutiveGaps;
                        }
                        ++chromatogramIndex;
                        continue;
                    }
                    ++consecutiveGaps;
                }
                consecutiveGaps = 0;
                chromatogramIndex = chromatogramRtIndex;
                for (k = globalRtIndex; k >= 0 && chromatogramIndex >= 0 && consecutiveGaps <= 3; --k) {
                    if (Math.abs(globalTime[k] - chromatogramTime[chromatogramIndex]) < 0.01) {
                        if (chromatogramIntensities[chromatogramIndex] > 0.0) {
                            consecutiveGaps = 0;
                            cStartIdx = chromatogramIndex;
                            startIdx = k;
                            maxIntensity = Math.max(maxIntensity, chromatogramIntensities[chromatogramIndex]);
                            peakelIndexes.add(chromatogramIndex);
                        } else {
                            ++consecutiveGaps;
                        }
                        --chromatogramIndex;
                        continue;
                    }
                    ++consecutiveGaps;
                }
                double area = -1.0;
                if (!peakelIndexes.isEmpty()) {
                    peakelIndexes.sort(Integer::compareTo);
                    area = 0.0;
                    for (int k2 = 1; k2 < peakelIndexes.size(); ++k2) {
                        int prevIdx = (Integer)peakelIndexes.get(k2 - 1);
                        int currIdx = (Integer)peakelIndexes.get(k2);
                        area += (chromatogramIntensities[prevIdx] + chromatogramIntensities[currIdx]) * (chromatogramTime[currIdx] - chromatogramTime[prevIdx]) / 2.0;
                    }
                    if (startIdx > 1) {
                        int firstIdx = (Integer)peakelIndexes.get(0);
                        area += chromatogramIntensities[firstIdx] * (chromatogramTime[firstIdx] - globalTime[startIdx - 1]) / 2.0;
                    }
                    if (endIdx < globalTime.length - 2) {
                        int lastIdx = (Integer)peakelIndexes.get(peakelIndexes.size() - 1);
                        area += chromatogramIntensities[lastIdx] * (globalTime[endIdx + 1] - chromatogramTime[lastIdx]) / 2.0;
                    }
                }
                BasePeakel peakel = new BasePeakel((chromatogram.getMaxMz() + chromatogram.getMinMz()) / 2.0, (float)chromatogramTime[chromatogramRtIndex] * 60.0f, (float)chromatogramTime[cStartIdx] * 60.0f, (float)chromatogramTime[cEndIdx] * 60.0f, rawFile, request.getMsLevel());
                if (maxIntensity > 0.0) {
                    peakel.setApexIntensity((float)maxIntensity);
                }
                if (area > 0.0) {
                    peakel.setArea((float)area);
                }
                if (endIdx - startIdx > 0) {
                    peakel.setScanCount(endIdx - startIdx + 1);
                }
                if (request.getMsLevel() > 1) {
                    peakel.setParentMz(request.getMz());
                }
                return new AnnotatedChromatogram(chromatogram, peakel);
            }
        }
        catch (Exception e) {
            logger.error("Annotation failed", (Throwable)e);
        }
        return new AnnotatedChromatogram(chromatogram, null);
    }

    private double[] getElutionTimes(IRawFile rawFile, ExtractionRequest request) {
        if (!rawFile.isDIAFile() || request.getMsLevel() == 1) {
            return rawFile.getElutionTimes(request.getMsLevel());
        }
        Map<SpectrumHeader, IsolationWindow> selection = rawFile.getIsolationWindowByMs2Headers().entrySet().stream().filter(e -> ((IsolationWindow)((Object)((Object)e.getValue()))).contains(request.getMz())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return selection.keySet().stream().mapToDouble(h -> (double)h.getElutionTime() / 60.0).sorted().toArray();
    }
}

