/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.processing.IAnnotator;
import fr.proline.mzscope.processing.PeakelAnnotatorImpl;
import fr.proline.mzscope.ui.dialog.ExtractionParamsDialog;
import java.util.HashMap;
import java.util.Map;

public class PeakelAnnotator
implements IAnnotator {
    Map<IRawFile, PeakelAnnotatorImpl> annotators = null;
    FeaturesExtractionRequest extractionParams = null;

    @Override
    public AnnotatedChromatogram annotate(IRawFile rawFile, IChromatogram chromatogram, ExtractionRequest request, Integer expectedCharge) {
        if (this.annotators == null) {
            ExtractionParamsDialog dialog = new ExtractionParamsDialog(null, true, false);
            dialog.setExtractionParamsTitle("Detect Peakels Parameters");
            dialog.showExtractionParamsDialog();
            FeaturesExtractionRequest.Builder builder = dialog.getExtractionParams();
            if (builder == null) {
                return new AnnotatedChromatogram(chromatogram, null);
            }
            builder.setExtractionMethod(FeaturesExtractionRequest.ExtractionMethod.DETECT_PEAKELS);
            this.extractionParams = builder.build();
            this.annotators = new HashMap<IRawFile, PeakelAnnotatorImpl>();
        }
        if (!this.annotators.containsKey(rawFile)) {
            this.annotators.put(rawFile, new PeakelAnnotatorImpl(rawFile, this.extractionParams));
        }
        return this.annotators.get(rawFile).annotate(chromatogram, request, expectedCharge);
    }
}

