/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.ui.ChromatogramPanel;
import fr.proline.mzscope.ui.IRawFileLoading;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.SpectrumPanel;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import fr.proline.mzscope.utils.KeyEventDispatcherDecorator;
import fr.proline.mzscope.utils.MzScopeCallback;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.graphics.ExtendableButtonPanel;
import fr.proline.studio.graphics.marker.IntervalMarker;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRawFilePanel
extends JPanel
implements IRawFileViewer,
KeyEventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRawFilePanel.class);
    private boolean displayScan = true;
    private Display.Mode displayMode = Display.Mode.REPLACE;
    protected ChromatogramPanel chromatogramPanel;
    protected SpectrumPanel spectrumPanel;
    protected JToolBar chromatogramToolbar;
    protected Spectrum currentScan;
    private JToggleButton showMS2EventsButton;
    private JLayeredPane m_layeredPane;
    protected IRawFileLoading rawFileLoading;
    private boolean forceFittedToCentroid;

    public AbstractRawFilePanel() {
        this.init();
    }

    public void setDisplayScan(boolean displayScan) {
        this.displayScan = displayScan;
    }

    public void setRawFileLoading(IRawFileLoading rawFileLoading) {
        this.rawFileLoading = rawFileLoading;
    }

    private void init() {
        this.initComponents();
        this.spectrumPanel.initComponents();
        KeyEventDispatcherDecorator.addKeyEventListener(this);
    }

    @Override
    public void changeForceFittedToCentroid() {
        this.forceFittedToCentroid = !this.forceFittedToCentroid;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.m_layeredPane = new JLayeredPane();
        this.add((Component)this.m_layeredPane, "Center");
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel chromatogramContainerPanel = new JPanel();
        chromatogramContainerPanel.setLayout(new BorderLayout());
        chromatogramContainerPanel.add((Component)this.getChromatogramPanel(), "Center");
        chromatogramContainerPanel.add((Component)this.getChromatogramToolbar(), "North");
        if (this.displayScan) {
            JSplitPane splitPane = new JSplitPane();
            splitPane.setDividerLocation(160);
            splitPane.setOrientation(0);
            splitPane.setResizeWeight(0.5);
            splitPane.setCursor(new Cursor(0));
            splitPane.setDoubleBuffered(true);
            splitPane.setOneTouchExpandable(true);
            splitPane.setTopComponent(chromatogramContainerPanel);
            splitPane.setBottomComponent(this.getSpectrumPanel());
            mainPanel.add((Component)splitPane, "Center");
        } else {
            mainPanel.add((Component)chromatogramContainerPanel, "Center");
        }
        this.m_layeredPane.add((Component)mainPanel, JLayeredPane.DEFAULT_LAYER);
        this.m_layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                mainPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                AbstractRawFilePanel.this.m_layeredPane.revalidate();
                AbstractRawFilePanel.this.m_layeredPane.repaint();
            }
        });
    }

    private ChromatogramPanel getChromatogramPanel() {
        if (this.chromatogramPanel == null) {
            this.chromatogramPanel = new ChromatogramPanel();
            this.chromatogramPanel.addPropertyChangeListener(evt -> this.displayScan(this.getCurrentRawfile().getSpectrumId(((Float)evt.getNewValue()).floatValue())));
        }
        return this.chromatogramPanel;
    }

    protected JPanel getSpectrumPanel() {
        if (this.spectrumPanel == null) {
            this.spectrumPanel = new SpectrumPanel(this);
            this.spectrumPanel.setLayout(new BorderLayout());
        }
        return this.spectrumPanel;
    }

    private JToolBar getChromatogramToolbar() {
        this.chromatogramToolbar = new JToolBar(0);
        this.chromatogramToolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this.chromatogramPanel.getChromatogramPlotPanel());
        this.chromatogramToolbar.add((Component)exportImageButton);
        JButton ticBtn = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TIC));
        ticBtn.setToolTipText("Display TIC Chromatogram");
        ticBtn.addActionListener(e -> this.displayTIC(-1));
        JButton displayTICbtn = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TIC));
        displayTICbtn.setToolTipText("Display TIC Chromatogram");
        displayTICbtn.addActionListener(e -> this.displayTIC(-1));
        JButton displayTICMS1btn = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TIC_MS1));
        displayTICMS1btn.setToolTipText("Display MS1 TIC Chromatogram");
        displayTICMS1btn.addActionListener(e -> this.displayTIC(1));
        ExtendableButtonPanel extendableButtonPanel = new ExtendableButtonPanel((AbstractButton)ticBtn);
        this.m_layeredPane.add((Component)extendableButtonPanel, JLayeredPane.PALETTE_LAYER);
        extendableButtonPanel.registerButton((AbstractButton)displayTICbtn);
        extendableButtonPanel.registerButton((AbstractButton)displayTICMS1btn);
        this.chromatogramToolbar.add(ticBtn);
        JButton displayBPIbtn = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.BPC));
        displayBPIbtn.setToolTipText("Display Base Peak Chromatogram");
        displayBPIbtn.addActionListener(e -> this.displayBPI());
        this.chromatogramToolbar.add(displayBPIbtn);
        this.chromatogramToolbar.add(this.getShowMS2Button());
        this.setMsMsEventButtonEnabled(false);
        JToggleButton overlayBtn = new JToggleButton();
        overlayBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OVERLAY));
        overlayBtn.setSelected(false);
        overlayBtn.setToolTipText("Overlay extracted chromatograms. This can also be done by using the Alt key");
        overlayBtn.addActionListener(e -> {
            this.displayMode = ((AbstractButton)e.getSource()).isSelected() ? Display.Mode.OVERLAY : Display.Mode.REPLACE;
        });
        this.chromatogramToolbar.add(overlayBtn);
        this.chromatogramToolbar.setFloatable(false);
        this.chromatogramToolbar.setRollover(true);
        return this.chromatogramToolbar;
    }

    protected AbstractButton getShowMS2Button() {
        if (this.showMS2EventsButton == null) {
            this.showMS2EventsButton = new JToggleButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.MS2), false);
            this.showMS2EventsButton.setToolTipText("Show or hide MS2 Events");
            this.showMS2EventsButton.addActionListener(e -> this.displayMsMsEvents(this.showMS2EventsButton.isSelected()));
        }
        return this.showMS2EventsButton;
    }

    protected void setMsMsEventButtonEnabled(boolean b) {
        this.showMS2EventsButton.setEnabled(b);
        if (!b) {
            this.hideMSMSEvents();
        }
    }

    @Override
    public Display.Mode getChromatogramDisplayMode() {
        return this.displayMode;
    }

    private void displayMsMsEvents(boolean showMsMsEvents) {
        if (showMsMsEvents) {
            this.showMSMSEvents();
        } else {
            this.hideMSMSEvents();
        }
    }

    public void showMSMSEvents() {
        if (this.chromatogramPanel.getCurrentChromatogram() == null) {
            return;
        }
        final double minMz = this.chromatogramPanel.getCurrentChromatogram().getMinMz();
        final double maxMz = this.chromatogramPanel.getCurrentChromatogram().getMaxMz();
        SwingWorker<List<Float>, Void> worker = new SwingWorker<List<Float>, Void>(){

            @Override
            protected List<Float> doInBackground() throws Exception {
                return AbstractRawFilePanel.this.getCurrentRawfile().getMsMsEvent(minMz, maxMz);
            }

            @Override
            protected void done() {
                try {
                    AbstractRawFilePanel.this.chromatogramPanel.showMSMSEvents((List)this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
            }
        };
        worker.execute();
    }

    public void hideMSMSEvents() {
        this.chromatogramPanel.hideMSMSEvents();
    }

    @Override
    public Color displayChromatogram(IChromatogram chromato, Display display) {
        this.setMsMsEventButtonEnabled(display.getMode() == Display.Mode.REPLACE);
        Color plotColor = this.chromatogramPanel.displayChromatogram(chromato, display);
        this.displayMsMsEvents(this.showMS2EventsButton.isSelected());
        return plotColor;
    }

    @Override
    public void displayChromatograms(Map<IRawFile, IChromatogram> chromatogramByRawFile, Display display) {
        this.displayChromatogram(chromatogramByRawFile.get(this.getCurrentRawfile()), display);
    }

    @Override
    public void extractAndDisplay(final ExtractionRequest params, final Display display, final MzScopeCallback callback) {
        if (this.rawFileLoading != null) {
            this.rawFileLoading.setWaitingState(true);
        }
        final IRawFile rawfile = this.getCurrentRawfile();
        if (!params.getMzRequestType().equals((Object)ExtractionRequest.Type.NONE)) {
            SwingWorker<IChromatogram, Void> worker = new SwingWorker<IChromatogram, Void>(){

                @Override
                protected IChromatogram doInBackground() throws Exception {
                    return rawfile.getXIC(params);
                }

                @Override
                protected void done() {
                    try {
                        IChromatogram c = (IChromatogram)this.get();
                        if (c != null) {
                            AbstractRawFilePanel.this.displayChromatogram(c, display);
                            AbstractRawFilePanel.this.setMsMsEventButtonEnabled(true);
                            if (callback != null) {
                                callback.callback(true);
                            }
                        } else {
                            String msg = StringUtils.formatString((String)params.toString(), (int)60);
                            JOptionPane.showMessageDialog(null, "The following extraction request did not produce any data: \n" + msg, "IChromatogram Extraction failure", 0);
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        logger.error("Error while extraction chromatogram", (Throwable)e);
                        if (callback != null) {
                            callback.callback(false);
                        }
                    }
                    finally {
                        if (AbstractRawFilePanel.this.rawFileLoading != null) {
                            AbstractRawFilePanel.this.rawFileLoading.setWaitingState(false);
                        }
                    }
                    AbstractRawFilePanel.this.updateLastExtractionRequest(params);
                }
            };
            worker.execute();
        } else {
            this.updateLastExtractionRequest(params);
        }
    }

    private void updateLastExtractionRequest(ExtractionRequest request) {
        MzScopePreferences.getInstance().setLastExtractionRequest(request);
        this.firePropertyChange("lastExtractionRequest", null, request);
    }

    @Override
    public void displayPeakel(final IPeakel peakel) {
        double ppm = MzScopePreferences.getInstance().getMzPPMTolerance();
        Object builder = ((ExtractionRequest.Builder)ExtractionRequest.builder(this).setMzTolPPM((float)ppm)).setMsLevel(peakel.getMsLevel());
        if (peakel.getMsLevel() == 1) {
            ((ExtractionRequest.Builder)builder).setMz(peakel.getMz());
        } else {
            ((ExtractionRequest.Builder)builder).setMz(peakel.getParentMz());
            ppm = MzScopePreferences.getInstance().getFragmentMzPPMTolerance();
            ((ExtractionRequest.Builder)builder).setFragmentMzTolPPM((float)ppm);
            ((ExtractionRequest.Builder)builder).setFragmentMz(peakel.getMz());
        }
        if (this.rawFileLoading != null) {
            this.rawFileLoading.setWaitingState(true);
        }
        final ExtractionRequest extractionRequest = ((ExtractionRequest.Builder)builder).build();
        SwingWorker<IChromatogram, Void> worker = new SwingWorker<IChromatogram, Void>(){

            @Override
            protected IChromatogram doInBackground() throws Exception {
                return AbstractRawFilePanel.this.getCurrentRawfile().getXIC(extractionRequest);
            }

            @Override
            protected void done() {
                try {
                    AbstractRawFilePanel.this.displayChromatogram((IChromatogram)this.get(), new Display(AbstractRawFilePanel.this.getChromatogramDisplayMode()));
                    AbstractRawFilePanel.this.chromatogramPanel.displayFeature(peakel, new Display(Collections.singletonList(new IntervalMarker(null, Color.ORANGE, Color.RED, (double)peakel.getFirstElutionTime() / 60.0, (double)peakel.getLastElutionTime() / 60.0))));
                    AbstractRawFilePanel.this.displayScan(AbstractRawFilePanel.this.getCurrentRawfile().getSpectrumId(peakel.getElutionTime()));
                    if (AbstractRawFilePanel.this.rawFileLoading != null) {
                        AbstractRawFilePanel.this.rawFileLoading.setWaitingState(false);
                    }
                }
                catch (InterruptedException ex) {
                    logger.error("Error while extraction feature chromatogram", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    logger.error("Error while extraction feature chromatogram", (Throwable)ex);
                }
                AbstractRawFilePanel.this.updateLastExtractionRequest(extractionRequest);
            }
        };
        worker.execute();
    }

    @Override
    public void displayScan(long index) {
        if (this.currentScan == null || index != (long)this.currentScan.getIndex().intValue()) {
            if (this.rawFileLoading != null) {
                this.rawFileLoading.setWaitingState(true);
            }
            this.currentScan = this.getCurrentRawfile().getSpectrum((int)index, this.forceFittedToCentroid);
            if (this.currentScan != null) {
                this.chromatogramPanel.setCurrentScanTime(this.currentScan.getRetentionTime());
                if (this.displayScan) {
                    this.spectrumPanel.displayScan(this.currentScan);
                    for (IChromatogram chromato : this.chromatogramPanel.getChromatograms()) {
                        if (chromato.getMinMz() == -1.0 || chromato.getMaxMz() == -1.0 || this.currentScan.getMsLevel() != 1) continue;
                        this.spectrumPanel.addMarkerRange(chromato.getMinMz(), chromato.getMaxMz());
                    }
                }
            }
            if (this.rawFileLoading != null) {
                this.rawFileLoading.setWaitingState(false);
            }
        }
    }

    @Override
    public void setReferenceSpectrum(Spectrum spectrum, Float scaleFactor) {
        this.spectrumPanel.setReferenceSpectrum(spectrum, scaleFactor);
    }

    @Override
    public Spectrum getCurrentSpectrum() {
        return this.currentScan;
    }

    @Override
    public IChromatogram getCurrentChromatogram() {
        return this.chromatogramPanel.getCurrentChromatogram();
    }

    @Override
    public Iterable<IChromatogram> getAllChromatograms() {
        return this.chromatogramPanel.getChromatograms();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.isConsumed() || e.getID() != 401) {
            return false;
        }
        if (this.currentScan == null) {
            e.consume();
            return true;
        }
        if ((e.getModifiersEx() & 0x80) != 0) {
            if (e.getKeyCode() == 37) {
                this.displayScan(this.getCurrentRawfile().getPreviousSpectrumId(this.currentScan.getIndex(), this.currentScan.getMsLevel()));
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 39) {
                this.displayScan(this.getCurrentRawfile().getNextSpectrumId(this.currentScan.getIndex(), this.currentScan.getMsLevel()));
                e.consume();
                return true;
            }
        } else {
            if (e.getKeyCode() == 37) {
                this.displayScan(this.spectrumPanel.getPreviousScanIndex(this.currentScan.getIndex()));
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 39) {
                this.displayScan(this.spectrumPanel.getNextScanIndex(this.currentScan.getIndex()));
                e.consume();
                return true;
            }
        }
        return false;
    }

    protected abstract void displayTIC(int var1);

    protected abstract void displayBPI();
}

