/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.ExtractionObject;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.processing.IAnnotator;
import fr.proline.mzscope.ui.BatchExtractionDialog;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.RawFileManager;
import fr.proline.mzscope.ui.model.ExtractionResultsTableModel;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.WindowManager;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExpansionTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.extendedtablemodel.ImportedDataTableModel;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchExtractionPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(BatchExtractionPanel.class);
    private static final String LAST_DIR = "mzscope.last.csv.extraction.directory";
    private List<ExtractionObject> m_extractions;
    private ExtractionResultsTableModel m_extractionResultsTableModel;
    private CompoundTableModel m_globalTableModel;
    private ImportedDataTableModel m_importedTableModel;
    private ExtractionResultsTable m_extractionResultsTable;
    private SwingWorker m_extractionWorker;
    private IMzScopeController m_viewersController;
    private JFileChooser m_fchooser;
    private MarkerContainerPanel m_markerContainerPanel;
    public static final int TOOLBAR_ALIGN_VERTICAL = 0;
    public static final int TOOLBAR_ALIGN_HORIZONTAL = 1;
    private int m_toolbarAlign = 1;

    public BatchExtractionPanel(IMzScopeController extractionResults, int align) {
        this.m_viewersController = extractionResults;
        this.m_toolbarAlign = align;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getExtractionResultsTable(), "Center");
        if (this.m_toolbarAlign == 1) {
            this.add((Component)this.getToolBar(), "North");
        } else if (this.m_toolbarAlign == 0) {
            this.add((Component)this.getToolBar(), "West");
        }
        this.m_fchooser = new JFileChooser();
        this.m_fchooser.setMultiSelectionEnabled(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.csv", "csv");
        this.m_fchooser.setFileFilter(filter);
    }

    private JToolBar getToolBar() {
        JToolBar toolbar = new JToolBar(this.m_toolbarAlign == 1 ? 0 : 1);
        toolbar.setFloatable(false);
        JButton clearBtn = new JButton();
        clearBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        clearBtn.setToolTipText("Clear all values");
        clearBtn.addActionListener(e -> this.clearAllValues());
        toolbar.add(clearBtn);
        JButton importCSVBtn = new JButton();
        importCSVBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE_IMPORT));
        importCSVBtn.setToolTipText("Import m/z values from a csv file...");
        importCSVBtn.addActionListener(e -> this.importCSVExtractions());
        toolbar.add(importCSVBtn);
        JButton iRTBtn = new JButton("iRT");
        iRTBtn.setToolTipText("indexed Retention Time Standard");
        iRTBtn.addActionListener(e -> {
            this.m_importedTableModel = null;
            this.setExtractions(BatchExtractionPanel.buildIRTRequest(this), null);
        });
        toolbar.add(iRTBtn);
        toolbar.addSeparator();
        JButton extractBtn = new JButton();
        extractBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.EXECUTE));
        extractBtn.setToolTipText("Start Extractions on all files");
        extractBtn.addActionListener(e -> this.startExtractions());
        toolbar.add(extractBtn);
        toolbar.addSeparator();
        ExportButton m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_extractionResultsTable.getModel()), "Extraction Values", (JXTable)this.m_extractionResultsTable);
        toolbar.add((Component)m_exportButton);
        FilterButton m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_extractionResultsTable.getModel())){

            protected void filteringDone() {
                logger.info("Filtering done ! ");
            }
        };
        toolbar.add((Component)m_filterButton);
        return toolbar;
    }

    private void clearAllValues() {
        this.m_extractionResultsTableModel = new ExtractionResultsTableModel();
        this.m_globalTableModel.setBaseModel((GlobalTableModelInterface)this.m_extractionResultsTableModel);
        this.m_globalTableModel.fireTableStructureChanged();
        this.m_importedTableModel = null;
    }

    private void importCSVExtractions() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String directory = prefs.get(LAST_DIR, this.m_fchooser.getCurrentDirectory().getAbsolutePath());
        this.m_fchooser.setCurrentDirectory(new File(directory));
        int result = this.m_fchooser.showOpenDialog(this);
        if (result == 0) {
            File csvFile = this.m_fchooser.getSelectedFile();
            String fileName = csvFile.getName();
            if (!fileName.endsWith(".csv")) {
                JOptionPane.showMessageDialog(this, "The file must be a csv file", "Error", 0);
                return;
            }
            prefs.put(LAST_DIR, csvFile.getParentFile().getAbsolutePath());
            this.m_importedTableModel = new ImportedDataTableModel();
            ImportedDataTableModel.loadFile((ImportedDataTableModel)this.m_importedTableModel, (String)csvFile.getAbsolutePath(), (char)';', (boolean)true, (boolean)false);
            int mzColumnIdx = this.findColumn((AbstractTableModel)this.m_importedTableModel, new String[]{"moz", "m/z", "mz"});
            int rtColumnIdx = this.findColumn((AbstractTableModel)this.m_importedTableModel, new String[]{"rt", "retention_time", "retention time", "elution_time", "elution time", "time"});
            int zColumnIdx = this.findColumn((AbstractTableModel)this.m_importedTableModel, new String[]{"charge", "z"});
            int fragColumnIdx = this.findColumn((AbstractTableModel)this.m_importedTableModel, new String[]{"frag_mz", "frag_moz", "frag_m/z", "fragment_mz", "fragment_moz", "fragment_m/z"});
            if (mzColumnIdx != -1) {
                ArrayList<Double> mzValues = new ArrayList<Double>();
                ArrayList<Double> rtValues = new ArrayList<Double>();
                ArrayList<Integer> zValues = new ArrayList<Integer>();
                ArrayList<Double> fragMzValues = new ArrayList<Double>();
                for (int k = 0; k < this.m_importedTableModel.getRowCount(); ++k) {
                    mzValues.add((Double)this.m_importedTableModel.getValueAt(k, mzColumnIdx));
                    rtValues.add(rtColumnIdx != -1 ? (Double)this.m_importedTableModel.getValueAt(k, rtColumnIdx) : -1.0);
                    zValues.add(zColumnIdx != -1 ? ((Long)this.m_importedTableModel.getValueAt(k, zColumnIdx)).intValue() : 0);
                    fragMzValues.add(fragColumnIdx != -1 ? (Double)this.m_importedTableModel.getValueAt(k, fragColumnIdx) : -1.0);
                }
                float moztol = MzScopePreferences.getInstance().getMzPPMTolerance();
                float fragMoztol = MzScopePreferences.getInstance().getFragmentMzPPMTolerance();
                ArrayList<ExtractionRequest> requests = new ArrayList<ExtractionRequest>();
                for (int k = 0; k < mzValues.size(); ++k) {
                    Object requestBuilder = ((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(this).setMzTolPPM(moztol)).setMz((Double)mzValues.get(k))).setElutionTime(((Double)rtValues.get(k)).floatValue());
                    if (fragColumnIdx == -1) {
                        requests.add(((ExtractionRequest.Builder)requestBuilder).build());
                        continue;
                    }
                    ((ExtractionRequest.Builder)((ExtractionRequest.Builder)((ExtractionRequest.Builder)requestBuilder).setMsLevel(2)).setFragmentMzTolPPM(fragMoztol)).setFragmentMz((Double)fragMzValues.get(k));
                    requests.add(((ExtractionRequest.Builder)requestBuilder).build());
                }
                this.setExtractions(requests, zValues);
            } else {
                JOptionPane.showMessageDialog(this, "No column named \"mz\",\"moz\" or \"m/z\" detected in the imported file.\n Verify the column headers (the column separator must be \";\")", "Error", 0);
            }
        }
    }

    private int findColumn(AbstractTableModel tableModel, String[] alternativeNames) {
        String name;
        int columnIdx = -1;
        String[] stringArray = alternativeNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (columnIdx = tableModel.findColumn(name = stringArray[i])) == -1; ++i) {
        }
        return columnIdx;
    }

    private void setExtractions(List<ExtractionRequest> extractionRequests, List<Integer> expectedCharge) {
        ArrayList<ExtractionObject> results = new ArrayList<ExtractionObject>();
        for (int k = 0; k < extractionRequests.size(); ++k) {
            ExtractionRequest request = extractionRequests.get(k);
            ExtractionObject extractionObject = new ExtractionObject(request, expectedCharge != null ? expectedCharge.get(k) : 0);
            results.add(extractionObject);
        }
        this.m_extractionResultsTableModel.setExtractions(results);
        if (this.m_importedTableModel != null) {
            this.m_globalTableModel.setBaseModel((GlobalTableModelInterface)new ExpansionTableModel((GlobalTableModelInterface)this.m_importedTableModel, (GlobalTableModelInterface)this.m_extractionResultsTableModel));
            this.m_globalTableModel.fireTableStructureChanged();
        }
        this.m_markerContainerPanel.setMaxLineNumber(extractionRequests.size());
        this.m_extractions = results;
    }

    private void startExtractions() {
        logger.info("startExtractions...");
        if (this.m_extractions == null) {
            logger.info("no extractions!");
            return;
        }
        final List<IRawFile> rawfiles = RawFileManager.getInstance().getAllFiles();
        BatchExtractionDialog dialog = new BatchExtractionDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            final IAnnotator annotator = dialog.getAnnotator();
            this.m_extractionResultsTableModel.setRawFiles(rawfiles);
            if (this.m_extractionWorker == null || this.m_extractionWorker.isDone()) {
                for (ExtractionObject extraction : this.m_extractions) {
                    extraction.setStatus(ExtractionObject.Status.REQUESTED);
                }
                this.m_extractionResultsTableModel.fireTableStructureChanged();
                this.m_extractionWorker = new SwingWorker<Integer, List<Object>>(){

                    @Override
                    protected Integer doInBackground() {
                        int count = 0;
                        for (ExtractionObject extraction : BatchExtractionPanel.this.m_extractions) {
                            for (IRawFile rawFile : rawfiles) {
                                long start = System.currentTimeMillis();
                                IChromatogram c = rawFile.getXIC(extraction.getRequest());
                                ++count;
                                ArrayList<Object> o = new ArrayList<Object>();
                                AnnotatedChromatogram ac = extraction.getElutionTime() > 0.0f ? annotator.annotate(rawFile, c, extraction.getRequest(), extraction.getExpectedCharge()) : new AnnotatedChromatogram(c, null);
                                o.add(ac);
                                o.add(rawFile);
                                o.add(extraction);
                                this.publish(o);
                                logger.info("extraction done in " + (System.currentTimeMillis() - start));
                            }
                            extraction.setStatus(ExtractionObject.Status.DONE);
                        }
                        return count;
                    }

                    @Override
                    protected void process(List<List<Object>> chunks) {
                        for (List<Object> o : chunks) {
                            AnnotatedChromatogram ac = (AnnotatedChromatogram)o.get(0);
                            IRawFile rf = (IRawFile)o.get(1);
                            ExtractionObject extraction = (ExtractionObject)o.get(2);
                            extraction.addChromatogram(rf, ac);
                        }
                        BatchExtractionPanel.this.m_extractionResultsTableModel.fireTableDataChanged();
                    }

                    @Override
                    protected void done() {
                        try {
                            logger.info("{} MS1 extraction done", this.get());
                        }
                        catch (InterruptedException | ExecutionException e) {
                            logger.error("Error while extracting chromatograms", (Throwable)e);
                        }
                    }
                };
                this.m_extractionWorker.execute();
            }
        }
    }

    private JComponent getExtractionResultsTable() {
        this.m_extractionResultsTableModel = new ExtractionResultsTableModel();
        JScrollPane jScrollPane = new JScrollPane();
        this.m_extractionResultsTable = new ExtractionResultsTable();
        this.m_globalTableModel = this.m_importedTableModel == null ? new CompoundTableModel((GlobalTableModelInterface)this.m_extractionResultsTableModel, true) : new CompoundTableModel((GlobalTableModelInterface)new ExpansionTableModel((GlobalTableModelInterface)this.m_importedTableModel, (GlobalTableModelInterface)this.m_extractionResultsTableModel), true);
        this.m_extractionResultsTable.setModel((TableModel)this.m_globalTableModel);
        this.m_extractionResultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExtractionObject extraction;
                int selRow;
                if (evt.getClickCount() == 2 && (selRow = BatchExtractionPanel.this.m_extractionResultsTable.getSelectedRow()) != -1 && (extraction = BatchExtractionPanel.this.m_extractionResultsTableModel.getExtractionResultAt(BatchExtractionPanel.this.getModelRowId(selRow))) != null && extraction.getStatus() == ExtractionObject.Status.DONE) {
                    Map<IRawFile, IChromatogram> mapChr = extraction.getChromatogramsMap();
                    List<IRawFile> rawfiles = RawFileManager.getInstance().getAllFiles();
                    int nbFiles = rawfiles.size();
                    if (nbFiles == 1) {
                        AnnotatedChromatogram chr;
                        if (mapChr.containsKey(rawfiles.get(0)) && (chr = (AnnotatedChromatogram)mapChr.get(rawfiles.get(0))) != null) {
                            IRawFileViewer viewer = BatchExtractionPanel.this.m_viewersController.getRawFileViewer(rawfiles.get(0), true);
                            if (chr.getAnnotation() != null) {
                                viewer.displayPeakel(chr.getAnnotation());
                            } else {
                                viewer.displayChromatogram(chr, new Display(Display.Mode.REPLACE));
                            }
                        }
                    } else {
                        IRawFileViewer panel = BatchExtractionPanel.this.m_viewersController.getTabbedMultiRawFileViewer();
                        panel.displayChromatograms(mapChr, new Display(Display.Mode.REPLACE));
                    }
                }
            }
        });
        jScrollPane.setViewportView((Component)((Object)this.m_extractionResultsTable));
        this.m_extractionResultsTable.setFillsViewportHeight(true);
        this.m_extractionResultsTable.setViewport(jScrollPane.getViewport());
        this.m_markerContainerPanel = new MarkerContainerPanel(jScrollPane, (MarkerComponentInterface)this.m_extractionResultsTable);
        return this.m_markerContainerPanel;
    }

    private int getModelRowId(int rowId) {
        if (this.m_globalTableModel.getRowCount() != 0) {
            rowId = this.m_extractionResultsTable.convertRowIndexToModel(rowId);
            rowId = this.m_globalTableModel.convertCompoundRowToBaseModelRow(rowId);
        }
        return rowId;
    }

    private static List<ExtractionRequest> buildIRTRequest(Object source) {
        float moztol = MzScopePreferences.getInstance().getMzPPMTolerance();
        ArrayList<ExtractionRequest> list = new ArrayList<ExtractionRequest>();
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(487.257)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(547.297)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(622.853)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(636.869)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(644.822)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(669.838)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(683.827)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(683.853)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(699.338)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(726.835)).build());
        list.add(((ExtractionRequest.Builder)((ExtractionRequest.Builder)ExtractionRequest.builder(source).setMzTolPPM(moztol)).setMz(776.929)).build());
        return list;
    }

    class ExtractionResultsTable
    extends DecoratedMarkerTable {
        ExtractionResultsTable() {
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        public void addTableModelListener(TableModelListener l) {
        }
    }
}

