/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.mzscope.ui.dialog.RawFilter;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;

public class ConvertRawFilesDialog
extends DefaultDialog {
    private JList<File> m_fileList;
    private JButton m_removeFileButton;
    private File m_converterExe;
    private String m_lastDirectory;
    private JTextField m_converterExeTF;
    private JTextField m_converterOptionTF;
    private static final String LAST_DIR = "mzscope.last.raw.directory";
    private static final String LAST_CONVERTER = "mzscope.converter.exe.path";
    private static final String LAST_CONVERTER_OPTION = "mzscope.converter.option";

    public ConvertRawFilesDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Convert Raw Files");
        this.setResizable(true);
        this.setMinimumSize(new Dimension(200, 240));
        this.initInternalPanel();
    }

    public List<File> getFilePaths() {
        ListModel<File> model = this.m_fileList.getModel();
        int nbFiles = model.getSize();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < nbFiles; ++i) {
            files.add(model.getElementAt(i));
        }
        return files;
    }

    public File getConverterExeFile() {
        return this.m_converterExe;
    }

    public String getConverterOption() {
        return this.m_converterOptionTF.getText().trim();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        JPanel fileSelectionPanel = this.createFileSelectionPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)fileSelectionPanel, c);
        JLabel converterLabel = new JLabel("Converter (.exe)");
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 0.2;
        c.gridwidth = 1;
        internalPanel.add((Component)converterLabel, c);
        ++c.gridx;
        c.weightx = 0.4;
        this.m_converterExeTF = new JTextField();
        Preferences prefs = NbPreferences.root();
        String rawConverterPath = prefs.get(LAST_CONVERTER, "");
        if (!StringUtils.isEmpty((CharSequence)rawConverterPath)) {
            this.m_converterExe = new File(rawConverterPath);
        }
        this.m_converterExeTF.setText(rawConverterPath);
        this.m_converterExeTF.setEditable(false);
        internalPanel.add((Component)this.m_converterExeTF, c);
        ++c.gridx;
        c.weightx = 0.4;
        JButton addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        addFileButton.setMargin(new Insets(2, 2, 2, 2));
        addFileButton.addActionListener(e -> {
            JFileChooser fchooser = new JFileChooser();
            fchooser.setMultiSelectionEnabled(false);
            if (!StringUtils.isEmpty((CharSequence)rawConverterPath)) {
                fchooser.setCurrentDirectory(new File(rawConverterPath));
            }
            fchooser.setFileSelectionMode(0);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Converter (.exe)", "exe");
            fchooser.setFileFilter(filter);
            fchooser.setAcceptAllFileFilterUsed(false);
            int result = fchooser.showOpenDialog(addFileButton);
            if (result == 0) {
                File file;
                this.m_converterExe = file = fchooser.getSelectedFile();
                this.m_converterExeTF.setText(file.getPath());
            }
        });
        internalPanel.add((Component)addFileButton, c);
        JLabel converterOptionLabel = new JLabel("Converter Options");
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 0.3;
        c.gridwidth = 1;
        internalPanel.add((Component)converterOptionLabel, c);
        ++c.gridx;
        c.weightx = 0.7;
        c.gridwidth = 2;
        this.m_converterOptionTF = new JTextField();
        String rawConverterOption = prefs.get(LAST_CONVERTER_OPTION, "");
        this.m_converterOptionTF.setText(rawConverterOption);
        internalPanel.add((Component)this.m_converterOptionTF, c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        this.m_fileList = new JList(new DefaultListModel());
        JScrollPane m_fileListScrollPane = new JScrollPane(this.m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        JButton m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        this.m_fileList.addListSelectionListener(e -> {
            boolean sometingSelected = this.m_fileList.getSelectedIndex() != -1;
            this.m_removeFileButton.setEnabled(sometingSelected);
        });
        m_addFileButton.addActionListener(e -> {
            this.setStatus(false, String.format("%d file(s)", this.m_fileList.getModel().getSize()));
            JFileChooser fchooser = new JFileChooser();
            fchooser.setFileSelectionMode(2);
            fchooser.setDialogTitle("Convert Raw file");
            fchooser.setFileFilter(new RawFilter());
            Preferences prefs = NbPreferences.root();
            this.m_lastDirectory = prefs.get(LAST_DIR, fchooser.getCurrentDirectory().getAbsolutePath());
            fchooser.setCurrentDirectory(new File(this.m_lastDirectory));
            fchooser.setMultiSelectionEnabled(true);
            int result = fchooser.showOpenDialog(null);
            if (result == 0) {
                File[] files;
                this.m_lastDirectory = fchooser.getCurrentDirectory().getAbsolutePath();
                for (File file : files = fchooser.getSelectedFiles()) {
                    ((DefaultListModel)this.m_fileList.getModel()).addElement(file);
                }
                this.setStatus(false, String.format("%d file(s)", this.m_fileList.getModel().getSize()));
            }
        });
        this.m_removeFileButton.addActionListener(e -> {
            List<File> selectedValues = this.m_fileList.getSelectedValuesList();
            for (File selectedValue : selectedValues) {
                ((DefaultListModel)this.m_fileList.getModel()).removeElement(selectedValue);
            }
            this.setStatus(false, String.format("%d file(s)", this.m_fileList.getModel().getSize()));
            this.m_removeFileButton.setEnabled(false);
        });
        return fileSelectionPanel;
    }

    private boolean checkParametersForOK() {
        int nbFiles = this.m_fileList.getModel().getSize();
        if (nbFiles == 0) {
            this.setStatus(true, "You must select a file to convert.");
            this.highlight(this.m_fileList);
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.m_converterExeTF.getText())) {
            this.setStatus(true, "You must specify path to raw2mzdb converter .exe file.");
            this.highlight(this.m_converterExeTF);
            return false;
        }
        if (!this.m_converterExe.exists()) {
            this.setStatus(true, "Specify to raw2mzdb converter .exe file doesn't exist.");
            this.highlight(this.m_converterExeTF);
            return false;
        }
        return true;
    }

    protected boolean okCalled() {
        if (!this.checkParametersForOK()) {
            return false;
        }
        this.saveParameters(NbPreferences.root());
        return true;
    }

    protected void saveParameters(Preferences preferences) {
        preferences.put(LAST_CONVERTER, this.m_converterExe.getAbsolutePath());
        preferences.put(LAST_DIR, this.m_lastDirectory);
        preferences.put(LAST_CONVERTER_OPTION, this.getConverterOption());
    }
}

