/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.PeakelsPatternPredictor;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.util.metrics.Metric;
import fr.proline.mzscope.model.BaseFeature;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.PairedPeakel;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.mzdb.MzdbFeatureWrapper;
import fr.proline.mzscope.processing.IsotopicPatternUtils;
import fr.proline.mzscope.processing.PeakelsHelper;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.dialog.RTParamDialog;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.ui.peakels.AbstractPeakelsPanel;
import fr.proline.mzscope.ui.peakels.FeaturesTableModel;
import fr.proline.mzscope.ui.peakels.PeakelsCompareTableModel;
import fr.proline.mzscope.ui.peakels.PeakelsPanel;
import fr.proline.studio.Exceptions;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.extendedtablemodel.ImportedDataTableModel;
import fr.proline.studio.utils.IconManager;
import java.awt.Window;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class PeakelsComparePanel
extends AbstractPeakelsPanel {
    private static final Logger logger = LoggerFactory.getLogger(PeakelsPanel.class);
    protected ArrayList<PairedPeakel> m_pairedPeakelArrayList = new ArrayList();
    protected PeakelsHelper m_helper = null;

    public PeakelsComparePanel(IMzScopeController controller) {
        super(controller);
    }

    @Override
    protected CompoundTableModel buildTableModel() {
        PeakelsCompareTableModel model = new PeakelsCompareTableModel();
        return new CompoundTableModel((GlobalTableModelInterface)model, true);
    }

    @Override
    protected List<IPeakel> getSelectedIPeakels() {
        if (this.m_pairedPeakelArrayList != null && !this.m_pairedPeakelArrayList.isEmpty() && this.m_table.getSelectedRowCount() > 0) {
            int[] selectedRows = this.m_table.getSelectedRows();
            ArrayList<IPeakel> selectedPeakels = new ArrayList<IPeakel>(selectedRows.length * 2);
            for (int row : selectedRows) {
                IPeakel p2;
                PairedPeakel pairedPeakel = this.m_pairedPeakelArrayList.get(row);
                IPeakel p1 = pairedPeakel.getPeakel1();
                if (p1 != null) {
                    selectedPeakels.add(p1);
                }
                if ((p2 = pairedPeakel.getPeakel2()) == null) continue;
                selectedPeakels.add(p2);
            }
            return selectedPeakels;
        }
        return null;
    }

    @Override
    protected List<Peakel> getSelectedPeakels() {
        List<IPeakel> selectedPeakels = this.getSelectedIPeakels();
        return selectedPeakels == null ? null : selectedPeakels.stream().map(p -> p.getPeakel()).collect(Collectors.toList());
    }

    @Override
    protected void matchIons(List<BaseFeature> ions, ImportedDataTableModel importedTableModel) {
        Metric metric = new Metric("ions matching");
        PeakelsHelper helper = this.getPeakelsHelper();
        float mzPPMTolerance = MzScopePreferences.getInstance().getMzPPMTolerance();
        IRawFile rawFile = this.m_pairedPeakelArrayList.get(0).getPeakel1().getRawFile();
        int matchingCount = 0;
        ArrayList<ImmutablePair> matchedFeatures = new ArrayList<ImmutablePair>();
        ArrayList<IPeakel> notFound = new ArrayList<IPeakel>();
        List duplicateIons = ions.stream().filter(i -> Collections.frequency(ions, i) > 1).collect(Collectors.toList());
        logger.info("ions duplicates summary :: {}", (Object)duplicateIons.size());
        int psmRtColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"rt.y"});
        for (int k = 0; k < ions.size(); ++k) {
            double ionMz = ions.get(k).getMz();
            double ionRt = (double)ions.get(k).getElutionTime() * 60.0;
            int ionCharge = ions.get(k).getCharge();
            double ionApexIntensity = ions.get(k).getApexIntensity();
            double tolDa = ionMz * (double)mzPPMTolerance / 1000000.0;
            float tolRt = 40.0f;
            List<Peakel> peakelList = helper.findCoelutingPeakels(ionMz - tolDa, ionMz + tolDa, (float)(ionRt - (double)tolRt), (float)(ionRt + (double)tolRt));
            if (peakelList == null) continue;
            List filteredPeakelList = peakelList.stream().filter(p -> ionRt >= (double)p.getFirstElutionTime() - 0.6 && ionRt <= (double)p.getLastElutionTime() + 0.6).collect(Collectors.toList());
            Peakel peakel = null;
            if (!filteredPeakelList.isEmpty()) {
                ++matchingCount;
                peakel = filteredPeakelList.size() == 1 ? (Peakel)filteredPeakelList.get(0) : filteredPeakelList.stream().collect(Collectors.minBy(Comparator.comparingDouble(p -> Math.abs(ionMz - p.getApexMz())))).get();
                List<Peakel> isotopes = helper.findFeatureIsotopes(peakel, ionCharge, mzPPMTolerance);
                Feature feature = new Feature(isotopes.get(0).getMz(), ionCharge, (Buffer)JavaConverters.asScalaBufferConverter(isotopes).asScala(), true);
                matchedFeatures.add(new ImmutablePair((Object)k, (Object)new MzdbFeatureWrapper(feature, rawFile, 1)));
                List<Peakel> coelutingPeakels = helper.findCoelutingPeakels(peakel.getApexMz() - (double)PeakelsHelper.HALF_MZ_WINDOW, peakel.getApexMz() + (double)PeakelsHelper.HALF_MZ_WINDOW, peakel.getElutionTime() - tolRt, peakel.getElutionTime() + tolRt);
                SpectrumData spectrum = helper.buildSpectrumFromPeakels(coelutingPeakels, peakel);
                TheoreticalIsotopePattern pattern = (TheoreticalIsotopePattern)IsotopicPatternUtils.predictIsotopicPattern((SpectrumData)spectrum, (double)peakel.getMz(), (double)((double)mzPPMTolerance))._2;
                if (pattern.charge() != ionCharge || Math.abs(pattern.monoMz() - peakel.getMz()) > tolDa) {
                    metric.incr("incorrect prediction");
                    logger.info("incorrect prediction: expected {}, {}+, predicted {}, {}+ (rt = {})", new Object[]{peakel.getMz(), ionCharge, pattern.monoMz(), pattern.charge(), ionRt / 60.0});
                    if (psmRtColumnIdx != -1) {
                        float psmRt = ((Double)importedTableModel.getValueAt(k, psmRtColumnIdx)).floatValue() * 60.0f;
                        this.testPrediction(psmRt, helper, peakel, tolRt, mzPPMTolerance, tolDa, ionCharge, metric, "incorrect psm rt");
                    }
                    if (pattern.charge() != ionCharge) {
                        metric.incr("incorrect charge prediction");
                    }
                    if (!(Math.abs(pattern.monoMz() - peakel.getMz()) > tolDa)) continue;
                    metric.incr("incorrect mono mz prediction");
                    continue;
                }
                if (isotopes.size() > 1) {
                    double dm = (isotopes.get(1).getMz() - isotopes.get(0).getMz()) * (double)ionCharge;
                    if (Math.abs(dm - IsotopePatternEstimator.avgIsoMassDiff()) < 0.01) {
                        metric.addValue("isotopic dmass", dm);
                    } else {
                        metric.incr("missing second isotope detected");
                        logger.info("missing second isotope for {}; {}; {}; {}+", new Object[]{ionMz, ionRt / 60.0, ionApexIntensity, ionCharge});
                    }
                } else {
                    metric.incr("mono isotopic feature detected");
                }
                metric.addValue("correct prediction intensity distribution", ionApexIntensity);
                continue;
            }
            notFound.add(ions.get(k));
            logger.warn("no peakel found for {}, {}, {}, {}+", new Object[]{k, ionMz, ionRt / 60.0, ionCharge});
        }
        logger.info("Found {} matches over {}", (Object)matchingCount, (Object)ions.size());
        logger.info("Distinct features matched :: {}", (Object)matchedFeatures.stream().map(p -> (IFeature)p.getRight()).distinct().count());
        List featureList = matchedFeatures.stream().map(p -> (IFeature)p.getRight()).collect(Collectors.toList());
        List duplicates = featureList.stream().filter(i -> Collections.frequency(featureList, i) > 1).collect(Collectors.toList());
        logger.info("incorrect predictions:: ");
        logger.info(metric.toString());
        logger.info("Not found summary :: {}", (Object)notFound.size());
        Map result = matchedFeatures.stream().map(p -> (IFeature)p.getRight()).collect(Collectors.groupingBy(IFeature::getPeakelsCount, Collectors.toList()));
        for (Map.Entry e : result.entrySet()) {
            logger.info("matched Features with {} peakels: {} or {} distinct", new Object[]{e.getKey(), e.getValue().size(), e.getValue().stream().distinct().count()});
        }
        HashMap<String, List<IFeature>> map = new HashMap<String, List<IFeature>>();
        map.put("valid features", featureList);
        this.m_viewersController.displayFeatures(map);
    }

    protected void testPrediction(float psmRt, PeakelsHelper helper, Peakel peakel, float tolRt, double moztol, double tolDa, int expectedCharge, Metric metric, String prefix) {
        if (psmRt >= peakel.getFirstElutionTime() && psmRt <= peakel.getLastElutionTime()) {
            List<Peakel> coelutingPeakels = helper.findCoelutingPeakels(peakel.getApexMz() - (double)PeakelsHelper.HALF_MZ_WINDOW, peakel.getApexMz() + (double)PeakelsHelper.HALF_MZ_WINDOW, psmRt - tolRt, psmRt + tolRt);
            int idx = Arrays.binarySearch(peakel.getElutionTimes(), psmRt);
            idx = idx < 0 ? ~idx : idx;
            Tuple2 pairs = PeakelsPatternPredictor.slicePeakels((Seq)((Seq)JavaConverters.asScalaBufferConverter(coelutingPeakels).asScala()), (long)peakel.getSpectrumIds()[idx], (int)1);
            List objectList = (List)JavaConverters.bufferAsJavaListConverter((Buffer)((Buffer)pairs._1)).asJava();
            double[] mzList = new double[objectList.size()];
            int j = 0;
            for (Object o : objectList) {
                mzList[j++] = (Double)o;
            }
            objectList = (List)JavaConverters.bufferAsJavaListConverter((Buffer)((Buffer)pairs._2)).asJava();
            float[] intensitiesList = new float[objectList.size()];
            j = 0;
            for (Object o : objectList) {
                intensitiesList[j++] = ((Float)o).floatValue();
            }
            SpectrumData spectrum = new SpectrumData(mzList, intensitiesList);
            TheoreticalIsotopePattern pattern = (TheoreticalIsotopePattern)IsotopicPatternUtils.predictIsotopicPattern((SpectrumData)spectrum, (double)peakel.getMz(), (double)moztol)._2;
            if (pattern.charge() != expectedCharge || Math.abs(pattern.monoMz() - peakel.getMz()) > tolDa) {
                metric.incr(prefix + " incorrect prediction");
            } else {
                metric.incr(prefix + " prediction rescued");
            }
        } else {
            metric.incr(prefix + " best psm outside peakel bounds");
        }
    }

    @Override
    protected JToolBar initToolbar() {
        JToolBar toolbar = super.initToolbar();
        JButton buildSpectrumBtn = new JButton();
        buildSpectrumBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CENTROID_SPECTRA));
        buildSpectrumBtn.setToolTipText("Build Spectrum from peakels");
        buildSpectrumBtn.addActionListener(e -> this.buildSpectrumFromPeakels());
        toolbar.add(buildSpectrumBtn);
        JButton buildFeaturesBtn = new JButton();
        buildFeaturesBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ISOTOPES_PREDICTION));
        buildFeaturesBtn.setToolTipText("Deconvolute peakels to features");
        buildFeaturesBtn.addActionListener(e -> this.buildFeatures());
        JButton matchIonsBtn = new JButton();
        matchIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE_IMPORT));
        matchIonsBtn.setToolTipText("Match (m/z,rt) values from a csv file...");
        matchIonsBtn.addActionListener(e -> this.matchCSVIons());
        toolbar.add(matchIonsBtn);
        toolbar.add(buildFeaturesBtn);
        return toolbar;
    }

    private void buildSpectrumFromPeakels() {
        List<IPeakel> peakels = this.getSelectedIPeakels();
        Peakel peakel = peakels.get(0).getPeakel();
        PeakelsHelper helper = this.getPeakelsHelper();
        RTParamDialog dialog = new RTParamDialog((Window)this.getTopLevelAncestor());
        dialog.setHelpHeaderText("The spectrum construction needs to search for co-eluting peakels.<br> The coelution definition is based on the following time tolerance.");
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            List<Peakel> coelutingPeakels = helper.findCoelutingPeakels(peakel.getApexMz() - 5.0, peakel.getApexMz() + 5.0, peakel.getElutionTime() - dialog.getRTTolerance(), peakel.getLastElutionTime() + dialog.getRTTolerance());
            SpectrumData spectrumData = helper.buildSpectrumFromPeakels(coelutingPeakels, peakel);
            logger.info(Arrays.toString(spectrumData.getMzList()));
            logger.info(Arrays.toString(spectrumData.getIntensityList()));
            Spectrum spectrum = new Spectrum(-1, peakel.getElutionTime(), spectrumData.getMzList(), spectrumData.getIntensityList(), 1, Spectrum.ScanType.CENTROID);
            this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).setReferenceSpectrum(spectrum, Float.valueOf(1.0f));
        }
    }

    private void buildFeatures() {
        RTParamDialog dialog = new RTParamDialog(null);
        dialog.setHelpHeaderText("The feature detection (especially charge state detection) needs to <br>group co-eluting peakels. The coelution definition is based on the following <br>time tolerance.");
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            try {
                PeakelsHelper helper = this.getPeakelsHelper();
                Map<String, List<Feature>> features = helper.deisotopePeakels(MzScopePreferences.getInstance().getMzPPMTolerance(), dialog.getRTTolerance());
                HashMap<String, List<IFeature>> wrappedFeatures = new HashMap<String, List<IFeature>>();
                IRawFile rawFile = this.m_pairedPeakelArrayList.get(0).getPeakel1().getRawFile();
                for (Map.Entry<String, List<Feature>> e : features.entrySet()) {
                    ArrayList listIFeatures = new ArrayList(e.getValue().size());
                    e.getValue().forEach(f -> listIFeatures.add(new MzdbFeatureWrapper((Feature)f, rawFile, 1)));
                    wrappedFeatures.put(e.getKey(), listIFeatures);
                }
                this.m_viewersController.displayFeatures(wrappedFeatures);
            }
            catch (StreamCorruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SQLiteException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private PeakelsHelper getPeakelsHelper() {
        return null;
    }

    public void setPeakels(ArrayList<PairedPeakel> pairedPeakelArrayList) {
        if (pairedPeakelArrayList == null) {
            pairedPeakelArrayList = new ArrayList();
        }
        this.m_modelSelectedRowBeforeSort = -1;
        this.m_helper = null;
        ((PeakelsCompareTableModel)this.m_compoundTableModel.getBaseModel()).setPeakels(pairedPeakelArrayList);
        this.m_pairedPeakelArrayList = pairedPeakelArrayList;
        this.m_markerContainerPanel.setMaxLineNumber(pairedPeakelArrayList.size());
        this.m_table.getColumnExt(this.m_table.convertColumnIndexToView(FeaturesTableModel.COLTYPE_FEATURE_RAWFILE.getIndex())).setVisible(true);
    }
}

