/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.utils;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import fr.profi.mzdb.model.Feature;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInspectorPanel
extends PropertySheetPanel {
    private static Logger logger = LoggerFactory.getLogger(ObjectInspectorPanel.class);
    private Object bean;

    public ObjectInspectorPanel() {
        this.getTable().setEditorFactory((PropertyEditorFactory)new PropertyEditorRegistryEx());
        PropertyRendererRegistry renderer = (PropertyRendererRegistry)this.getTable().getRendererFactory();
        DefaultCellRenderer r = new DefaultCellRenderer();
        r.setShowOddAndEvenRows(false);
        renderer.registerRenderer(Enum.class, (TableCellRenderer)r);
        this.setMode(0);
        this.setToolBarVisible(false);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
    }

    public ObjectInspectorPanel(Class beanClass) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException exp) {
            logger.error("", (Throwable)exp);
        }
        this.getTable().setEditorFactory((PropertyEditorFactory)new PropertyEditorRegistryEx());
        PropertyRendererRegistry renderer = (PropertyRendererRegistry)this.getTable().getRendererFactory();
        DefaultCellRenderer r = new DefaultCellRenderer();
        r.setShowOddAndEvenRows(false);
        renderer.registerRenderer(Enum.class, (TableCellRenderer)r);
        this.setMode(0);
        this.setToolBarVisible(false);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
        this.setBeanInfo(beanInfo);
    }

    public ObjectInspectorPanel(Object bean) {
        this.bean = bean;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException exp) {
            logger.error("", (Throwable)exp);
        }
        this.getTable().setEditorFactory((PropertyEditorFactory)new PropertyEditorRegistryEx());
        PropertyEditorRegistry editor = (PropertyEditorRegistry)this.getTable().getEditorFactory();
        PropertyRendererRegistry renderer = (PropertyRendererRegistry)this.getTable().getRendererFactory();
        DefaultCellRenderer r = new DefaultCellRenderer();
        r.setShowOddAndEvenRows(false);
        renderer.registerRenderer(Enum.class, (TableCellRenderer)r);
        this.setMode(0);
        this.setToolBarVisible(false);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
        this.setBeanInfo(beanInfo);
        Property[] properties = this.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].readFromObject(bean);
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Property prop = (Property)evt.getSource();
                prop.writeToObject(ObjectInspectorPanel.this.bean);
            }
        };
        this.addPropertySheetChangeListener(listener);
    }

    public void setBean(Object bean) {
        this.bean = bean;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException exp) {
            logger.error("", (Throwable)exp);
        }
        this.setBeanInfo(beanInfo);
        Property[] properties = this.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].readFromObject(bean);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        f.getContentPane().setLayout(new BorderLayout());
        ObjectInspectorPanel i = new ObjectInspectorPanel(Feature.class);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setViewportView((Component)((Object)i));
        f.getContentPane().add(jScrollPane3);
        f.setVisible(true);
    }

    private static class PropertyEditorRegistryEx
    extends PropertyEditorRegistry {
        private PropertyEditorRegistryEx() {
        }

        public synchronized PropertyEditor getEditor(Class type) {
            PropertyEditor editor = super.getEditor(type);
            Class c = type;
            while (editor == null) {
                if ((c = c.getSuperclass()) == null) {
                    return editor;
                }
                editor = super.getEditor(c);
            }
            return editor;
        }
    }
}

