/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.system;

import fr.profi.util.StringUtils;
import fr.profi.util.system.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OSInfo {
    private static final Logger LOG = LoggerFactory.getLogger(OSInfo.class);
    private static final String OS_NAME_KEY = "os.name";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String MAC = "mac";
    private static final String OS_ARCH_KEY = "os.arch";
    private static final String SUN_ARCH_DATA_MODEL_KEY = "sun.arch.data.model";

    private OSInfo() {
    }

    public static OSType getOSType() {
        OSType result = null;
        String osName = System.getProperty(OS_NAME_KEY);
        if (osName == null) {
            LOG.warn("Unable to retrieve \"{}\" system property", (Object)OS_NAME_KEY);
        } else {
            String normalizedOsName = osName.toLowerCase();
            if (normalizedOsName.contains(LINUX)) {
                switch (OSInfo.getArch()) {
                    case X86: {
                        result = OSType.LINUX_I386;
                        break;
                    }
                    case AMD64: {
                        result = OSType.LINUX_AMD64;
                        break;
                    }
                    default: {
                        LOG.warn("Unknown Linux arch (amd64 / i386) type");
                        break;
                    }
                }
            } else if (normalizedOsName.contains(WINDOWS)) {
                switch (OSInfo.getArch()) {
                    case X86: {
                        result = OSType.WINDOWS_X86;
                        break;
                    }
                    case AMD64: {
                        result = OSType.WINDOWS_AMD64;
                        break;
                    }
                    default: {
                        LOG.warn("Unknown Windows arch (amd64 / x86) type");
                        break;
                    }
                }
            } else if (normalizedOsName.contains(MAC)) {
                switch (OSInfo.getArch()) {
                    case X86: {
                        result = OSType.MAC_I386;
                        break;
                    }
                    case AMD64: {
                        result = OSType.MAC_AMD64;
                        break;
                    }
                    default: {
                        LOG.warn("Unknown Mac arch (amd64 / x86) type");
                        break;
                    }
                }
            } else {
                LOG.warn("Unknown OS [{}]", (Object)osName);
            }
        }
        return result;
    }

    private static ARCH getArch() {
        ARCH result = null;
        String sunDataModel = System.getProperty(SUN_ARCH_DATA_MODEL_KEY);
        if (sunDataModel == null) {
            LOG.warn("Unable to retrieve \"{}\" system property", (Object)SUN_ARCH_DATA_MODEL_KEY);
        } else if (sunDataModel.contains(ARCH.AMD64.getSunDataModel())) {
            result = ARCH.AMD64;
        } else if (sunDataModel.contains(ARCH.X86.getSunDataModel())) {
            result = ARCH.X86;
        } else {
            LOG.warn("Unknown SUN arch data model [{}]", (Object)sunDataModel);
        }
        String osArch = System.getProperty(OS_ARCH_KEY);
        if (osArch == null) {
            LOG.warn("Unable to retrieve \"{}\" system property", (Object)OS_ARCH_KEY);
        } else if (osArch.contains(ARCH.AMD64.getSunDataModel())) {
            if (result == null) {
                result = ARCH.AMD64;
            } else if (result != ARCH.AMD64) {
                LOG.warn("SUN arch data model {} differ from OS arch {}", (Object)result, (Object)ARCH.AMD64);
            }
        } else if (osArch.contains(ARCH.X86.getSunDataModel()) || osArch.contains(ARCH.X86.getArchPattern())) {
            if (result == null) {
                result = ARCH.X86;
            } else if (result != ARCH.X86) {
                LOG.warn("SUN arch data model {} differ from OS arch {}", (Object)result, (Object)ARCH.X86);
            }
        } else {
            LOG.warn("Unknown OS arch [{}]", (Object)osArch);
        }
        return result;
    }

    private static final class ARCH
    extends Enum<ARCH> {
        public static final /* enum */ ARCH AMD64 = new ARCH("64", null);
        public static final /* enum */ ARCH X86 = new ARCH("32", "86");
        private final String m_sunDataModel;
        private final String m_archPattern;
        private static final /* synthetic */ ARCH[] $VALUES;

        public static ARCH[] values() {
            return (ARCH[])$VALUES.clone();
        }

        public static ARCH valueOf(String name) {
            return Enum.valueOf(ARCH.class, name);
        }

        private ARCH(String sunDataModel, String archPattern) {
            assert (!StringUtils.isEmpty(sunDataModel)) : "ARCH() invalid sunDataModel";
            this.m_sunDataModel = sunDataModel;
            this.m_archPattern = archPattern;
        }

        public String getSunDataModel() {
            return this.m_sunDataModel;
        }

        public String getArchPattern() {
            return this.m_archPattern;
        }

        private static /* synthetic */ ARCH[] $values() {
            return new ARCH[]{AMD64, X86};
        }

        static {
            $VALUES = ARCH.$values();
        }
    }
}

