/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mgf;

import fr.profi.mzknife.mgf.MGFRewriter;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFReader;
import fr.profi.mzscope.MSMSSpectrum;
import fr.profi.util.metrics.Metric;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFMerger
extends MGFRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(MGFMerger.class);
    private static final Pattern SCAN_PATTERN = Pattern.compile("scan\\W+([0-9]+)");
    private boolean m_filterSpectrum = true;
    private boolean m_replaceFragments = true;
    private Metric metric = new Metric(MGFMerger.class.getName());
    protected Map<Integer, List<MSMSSpectrum>> m_indexedFragmentSpectra = new HashMap<Integer, List<MSMSSpectrum>>();

    public MGFMerger(File srcPrecursorFile, File srcFragmentsFile, File m_dstFile) throws InvalidMGFFormatException {
        super(srcPrecursorFile, m_dstFile);
        MGFReader reader = new MGFReader();
        List fragmentSpectra = reader.read(srcFragmentsFile);
        for (MSMSSpectrum spectrum : fragmentSpectra) {
            this.metric.incr("fragments.file.scan_count");
            Integer scan = MGFMerger.getScan((String)spectrum.getAnnotation("TITLE"));
            if (scan >= 0) {
                List list = this.m_indexedFragmentSpectra.getOrDefault(scan, new ArrayList(2));
                list.add(spectrum);
                this.m_indexedFragmentSpectra.put(scan, list);
                continue;
            }
            LOG.warn("No index or scan found in title : " + (String)spectrum.getAnnotation("TITLE"));
            this.metric.incr("fragments.file.scan_not_found");
        }
        this.metric.setCounter("fragments.file.indexed_scans", Integer.valueOf(this.m_indexedFragmentSpectra.size()));
        long multipleMatchCount = this.m_indexedFragmentSpectra.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).count();
        this.metric.setCounter("fragments.file.multiple_match_count", Integer.valueOf((int)multipleMatchCount));
        LOG.info("index created : {} entries", (Object)this.m_indexedFragmentSpectra.size());
    }

    public void setFilterSpectrum(boolean filter) {
        this.m_filterSpectrum = filter;
    }

    public void setReplaceFragments(boolean replaceFragments) {
        this.m_replaceFragments = replaceFragments;
    }

    public void dumpMetric() {
        LOG.info(this.metric.toString());
    }

    @Override
    protected MSMSSpectrum getSpectrum2Export(MSMSSpectrum inSpectrum) {
        this.metric.incr("precursors.file.scan_count");
        Integer scan = MGFMerger.getScan((String)inSpectrum.getAnnotation("TITLE"));
        if (scan <= 0) {
            this.metric.incr("precursors.file.scan_not_found");
        }
        if (this.m_indexedFragmentSpectra.containsKey(scan)) {
            List<MSMSSpectrum> spectrumList = this.m_indexedFragmentSpectra.get(scan);
            MSMSSpectrum fragmentSpectrum = spectrumList.get(0);
            if (this.m_replaceFragments) {
                double[] masses = fragmentSpectrum.getMassValues();
                double[] intensities = fragmentSpectrum.getIntensityValues();
                MSMSSpectrum outSpectrum = new MSMSSpectrum(inSpectrum.getPrecursorMz(), inSpectrum.getPrecursorIntensity(), inSpectrum.getPrecursorCharge(), inSpectrum.getRetentionTime());
                inSpectrum.getAnnotations().forEachRemaining(a -> outSpectrum.setAnnotation(a, inSpectrum.getAnnotation(a)));
                for (int i = 0; i < masses.length; ++i) {
                    outSpectrum.addPeak(masses[i], intensities[i]);
                }
                return outSpectrum;
            }
            return inSpectrum;
        }
        LOG.info("no corresponding scan in fragmentsMGF");
        this.metric.incr("precursors.file.no_matching_scan_in_fragments_file");
        return this.m_filterSpectrum ? null : inSpectrum;
    }

    private static Integer getScan(String title) {
        String searchedTitle = title.toLowerCase().replace("index", "scan");
        Matcher m = SCAN_PATTERN.matcher(searchedTitle);
        if (m.find()) {
            String scanNumberStr = m.group(1);
            return Integer.parseInt(scanNumberStr);
        }
        return -1;
    }
}

