/*
 * Decompiled with CFR 0.152.
 */
package javolution.osgi.internal;

import javolution.util.FastTable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SLF4jLogServiceImpl
extends Thread
implements LogService {
    private static final Logger LOG = LoggerFactory.getLogger(SLF4jLogServiceImpl.class);
    private final FastTable<LogEvent> eventQueue = new FastTable();

    public SLF4jLogServiceImpl() {
        super("SLF4j Logging-Thread");
        this.setDaemon(true);
        this.start();
        Thread hook = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FastTable fastTable = SLF4jLogServiceImpl.this.eventQueue;
                synchronized (fastTable) {
                    try {
                        while (!SLF4jLogServiceImpl.this.eventQueue.isEmpty()) {
                            SLF4jLogServiceImpl.this.eventQueue.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    @Override
    public void log(int level, String message) {
        this.log(level, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int level, String message, Throwable exception) {
        LogEvent event = new LogEvent();
        event.level = level;
        event.message = message;
        event.exception = exception;
        FastTable<LogEvent> fastTable = this.eventQueue;
        synchronized (fastTable) {
            this.eventQueue.addFirst(event);
            this.eventQueue.notify();
        }
    }

    @Override
    public void log(ServiceReference sr, int level, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    LogEvent event;
                    FastTable<LogEvent> fastTable = this.eventQueue;
                    synchronized (fastTable) {
                        while (this.eventQueue.isEmpty()) {
                            this.eventQueue.wait();
                        }
                        event = this.eventQueue.pollLast();
                        this.eventQueue.notify();
                    }
                    if (event.exception == null) {
                        this.log(event);
                        continue;
                    }
                    this.logWithException(event);
                }
            }
            catch (InterruptedException error) {
                LOG.error("An Error Occurred While Logging", (Throwable)error);
                continue;
            }
            break;
        }
    }

    private void log(LogEvent event) {
        switch (event.level) {
            case 4: {
                LOG.debug(event.message);
                break;
            }
            case 2: {
                LOG.warn(event.message);
                break;
            }
            case 1: {
                LOG.error(event.message);
                break;
            }
            default: {
                LOG.info(event.message);
            }
        }
    }

    private void logWithException(LogEvent event) {
        switch (event.level) {
            case 4: {
                LOG.debug(event.message, event.exception);
                break;
            }
            case 2: {
                LOG.warn(event.message, event.exception);
                break;
            }
            case 1: {
                LOG.error(event.message, event.exception);
                break;
            }
            default: {
                LOG.info(event.message, event.exception);
            }
        }
    }

    private static class LogEvent {
        Throwable exception;
        int level;
        String message;

        private LogEvent() {
        }
    }
}

