/*
 * Decompiled with CFR 0.152.
 */
package javolution.osgi.internal;

import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceTrackerImpl<C> {
    private volatile ServiceTracker<C, C> tracker;
    private final Class<C> type;
    private final Class<? extends C> defaultImplClass;
    private C defaultImpl;

    public ServiceTrackerImpl(Class<C> type, Class<? extends C> defaultImplClass) {
        this.defaultImplClass = defaultImplClass;
        this.type = type;
    }

    public void activate(BundleContext bc) {
        ServiceTracker trk = new ServiceTracker(bc, this.type, null);
        trk.open();
        this.tracker = trk;
    }

    public void deactivate(BundleContext bc) {
        this.tracker.close();
        this.tracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Object[] services;
        ServiceTracker<C, C> trk = this.tracker;
        if (trk != null && (services = trk.getServices()) != null) {
            return services;
        }
        ServiceTrackerImpl serviceTrackerImpl = this;
        synchronized (serviceTrackerImpl) {
            if (this.defaultImpl == null) {
                try {
                    this.defaultImpl = this.defaultImplClass.newInstance();
                }
                catch (Throwable error) {
                    throw new RuntimeException(error);
                }
            }
        }
        return new Object[]{this.defaultImpl};
    }
}

