/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectStreamException;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.Cursor;
import javolution.text.DefaultTextFormat;
import javolution.text.TextContext;
import javolution.text.TextFormat;
import javolution.text.TypeFormat;
import javolution.util.ConstantTable;
import javolution.util.FastTable;
import javolution.util.internal.table.ConstantTableImpl;

@Realtime
@DefaultTextFormat(value=Decimal.class)
public final class Index
extends Number
implements Comparable<Index>,
ValueType {
    public static final Configurable<Integer> UNIQUE = new Configurable<Integer>(){

        @Override
        protected Integer getDefault() {
            return 1024;
        }

        @Override
        protected Integer initialized(Integer value) {
            return MathLib.min(value, 65536);
        }

        @Override
        protected Integer reconfigured(Integer oldCount, Integer newCount) {
            throw new UnsupportedOperationException("Unicity reconfiguration not supported.");
        }
    };
    public static final Index ZERO = new Index(0);
    private static final long serialVersionUID = 1536L;
    private static final Index[] INSTANCES = new Index[UNIQUE.get().intValue()];
    private static final ConstantTable<Index> INSTANCES_TABLE;
    private final int value;

    public static Index of(int value) {
        return value < INSTANCES.length ? INSTANCES[value] : new Index(value);
    }

    public static FastTable<Index> listOf(int ... values) {
        Index[] indices = new Index[values.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = Index.of(values[i]);
        }
        return new ConstantTable<Index>(new ConstantTableImpl<Index>(indices));
    }

    public static ConstantTable<Index> rangeOf(int fromIndex, int toIndex) {
        if (toIndex <= INSTANCES.length) {
            return INSTANCES_TABLE.subTable(fromIndex, toIndex);
        }
        Index[] indices = new Index[toIndex - fromIndex];
        int j = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            indices[j++] = Index.of(i);
        }
        return new ConstantTable<Index>(new ConstantTableImpl<Index>(indices));
    }

    private Index(int value) {
        this.value = value;
    }

    @Override
    public int compareTo(Index that) {
        return this.value - that.value;
    }

    @Override
    public int compareTo(int value) {
        return this.value - value;
    }

    public Index copy() {
        return this.value < INSTANCES.length ? this : new Index(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return this.value < INSTANCES.length ? this == obj : (obj instanceof Index ? ((Index)obj).value == this.value : false);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public Index next() {
        return Index.of(this.value + 1);
    }

    public Index previous() {
        return Index.of(this.value - 1);
    }

    protected final Object readResolve() throws ObjectStreamException {
        return Index.of(this.value);
    }

    public String toString() {
        return TextContext.getFormat(Index.class).format(this);
    }

    static {
        Index.INSTANCES[0] = ZERO;
        for (int i = 1; i < INSTANCES.length; ++i) {
            Index.INSTANCES[i] = new Index(i);
        }
        INSTANCES_TABLE = new ConstantTable<Index>(new ConstantTableImpl<Index>(INSTANCES));
    }

    public static class Decimal
    extends TextFormat<Index> {
        @Override
        public Appendable format(Index obj, Appendable dest) throws IOException {
            return TypeFormat.format(obj.intValue(), dest);
        }

        @Override
        public Index parse(CharSequence csq, Cursor cursor) throws IllegalArgumentException {
            return Index.of(TypeFormat.parseInt(csq, cursor));
        }
    }
}

