/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import java.util.Iterator;
import java.util.Map;
import javolution.util.function.Equality;
import javolution.util.internal.map.MapView;
import javolution.util.service.MapService;

public class UnmodifiableMapImpl<K, V>
extends MapView<K, V> {
    private static final long serialVersionUID = 1536L;

    public UnmodifiableMapImpl(MapService<K, V> target) {
        super(target);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unmodifiable");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.target().containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.target().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.target().keyComparator();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("Unmodifiable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Unmodifiable");
    }

    @Override
    public int size() {
        return this.target().size();
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.target().valueComparator();
    }

    @Override
    public MapService<K, V>[] split(int n, boolean updateable) {
        MapService[] subTargets = (MapService[])this.target().split(n, updateable);
        MapService[] result = new MapService[subTargets.length];
        for (int i = 0; i < subTargets.length; ++i) {
            result[i] = new UnmodifiableMapImpl<K, V>(subTargets[i]);
        }
        return result;
    }

    private class IteratorImpl
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> targetIterator;

        private IteratorImpl() {
            this.targetIterator = UnmodifiableMapImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.targetIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only Map.");
        }
    }
}

