/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Arrays;

public class BenchmarkDoubleDHT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static int[] sizes1D = new int[]{65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 10368, 27000, 75600, 165375, 362880, 1562500, 0x310000, 6250000};
    private static int[] sizes2D = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 260, 520, 1050, 1458, 1960, 2916, 4116, 5832};
    private static int[] sizes3D = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 5, 17, 30, 95, 180, 270, 324, 420};
    private static boolean doScaling = false;

    private BenchmarkDoubleDHT() {
    }

    public static void parseArguments(String[] args) {
        if (args.length > 0) {
            int i;
            nthread = Integer.parseInt(args[0]);
            threadsBegin2D = Integer.parseInt(args[1]);
            threadsBegin3D = Integer.parseInt(args[2]);
            niter = Integer.parseInt(args[3]);
            doWarmup = Boolean.parseBoolean(args[4]);
            doScaling = Boolean.parseBoolean(args[5]);
            nsize = Integer.parseInt(args[6]);
            sizes1D = new int[nsize];
            sizes2D = new int[nsize];
            sizes3D = new int[nsize];
            for (i = 0; i < nsize; ++i) {
                BenchmarkDoubleDHT.sizes1D[i] = Integer.parseInt(args[7 + i]);
            }
            for (i = 0; i < nsize; ++i) {
                BenchmarkDoubleDHT.sizes2D[i] = Integer.parseInt(args[7 + nsize + i]);
            }
            for (i = 0; i < nsize; ++i) {
                BenchmarkDoubleDHT.sizes3D[i] = Integer.parseInt(args[7 + nsize + nsize + i]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] times = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 1D of size " + sizes1D[i]);
            DoubleDHT_1D dht = new DoubleDHT_1D(sizes1D[i]);
            double[] x = new double[sizes1D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                dht.forward(x);
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                dht.forward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                elapsedTime = System.nanoTime();
                dht.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
            }
            times[i] = av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dht = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, times);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] times = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleDHT_2D dht2 = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
            double[] x = new double[sizes2D[i] * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                elapsedTime = System.nanoTime();
                dht2.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
            }
            times[i] = av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dht2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] times = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleDHT_2D dht2 = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
            double[][] x = new double[sizes2D[i]][sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dht2.forward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                elapsedTime = System.nanoTime();
                dht2.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
            }
            times[i] = av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dht2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] times = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleDHT_3D dht3 = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[] x = new double[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                elapsedTime = System.nanoTime();
                dht3.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
            }
            times[i] = av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dht3 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] times = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Forward DHT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleDHT_3D dht3 = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[][][] x = new double[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dht3.forward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                elapsedTime = System.nanoTime();
                dht3.forward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
            }
            times[i] = av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dht3 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleForwardDHT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void main(String[] args) {
        BenchmarkDoubleDHT.parseArguments(args);
        BenchmarkDoubleDHT.benchmarkForward_1D();
        BenchmarkDoubleDHT.benchmarkForward_2D_input_1D();
        BenchmarkDoubleDHT.benchmarkForward_2D_input_2D();
        BenchmarkDoubleDHT.benchmarkForward_3D_input_1D();
        BenchmarkDoubleDHT.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

