/*
 * Decompiled with CFR 0.152.
 */
package mr.go.sgfilter;

import mr.go.sgfilter.Preprocessor;

public class Linearizer
implements Preprocessor {
    private float truncateRatio = 0.5f;

    public Linearizer() {
    }

    public Linearizer(float truncateRatio) {
        if (truncateRatio < 0.0f) {
            throw new IllegalArgumentException("truncateRatio < 0");
        }
        this.truncateRatio = truncateRatio;
    }

    @Override
    public void apply(double[] data) {
        int n = data.length - 1;
        double[] deltas = this.computeDeltas(data);
        block0: for (int i = 0; i < n; ++i) {
            if (!(deltas[i] > (double)this.truncateRatio)) continue;
            for (int k = i + 1; k < n; ++k) {
                if (!(deltas[k] <= (double)this.truncateRatio)) continue;
                this.linest(data, i, k);
                i = k - 1;
                continue block0;
            }
            this.linest(data, i, n);
            break;
        }
    }

    protected double[] computeDeltas(double[] data) {
        int n = data.length;
        double[] deltas = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            deltas[i] = data[i] == 0.0 && data[i + 1] == 0.0 ? 0.0 : Math.abs(1.0 - data[i + 1] / data[i]);
        }
        return deltas;
    }

    public float getTruncateRatio() {
        return this.truncateRatio;
    }

    protected void linest(double[] data, int x0, int x1) {
        if (x0 + 1 == x1) {
            return;
        }
        double slope = (data[x1] - data[x0]) / (double)(x1 - x0);
        double y0 = data[x0];
        for (int x = x0 + 1; x < x1; ++x) {
            data[x] = slope * (double)(x - x0) + y0;
        }
    }

    public void setTruncateRatio(float truncateRatio) {
        if (truncateRatio < 0.0f) {
            throw new IllegalArgumentException("truncateRatio < 0");
        }
        this.truncateRatio = truncateRatio;
    }
}

