/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.BufferR032;
import org.ojalgo.array.BufferR064;
import org.ojalgo.array.BufferZ008;
import org.ojalgo.array.BufferZ016;
import org.ojalgo.array.BufferZ032;
import org.ojalgo.array.BufferZ064;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.FillAll;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.OperationVoid;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.math.MathType;

public abstract class BufferArray
extends PlainArray<Double>
implements AutoCloseable {
    public static final Factory R032 = new Factory(MathType.R032, BufferR032::new);
    public static final Factory R064 = new Factory(MathType.R064, BufferR064::new);
    public static final Factory Z008 = new Factory(MathType.Z008, BufferZ008::new);
    public static final Factory Z016 = new Factory(MathType.Z016, BufferZ016::new);
    public static final Factory Z032 = new Factory(MathType.Z032, BufferZ032::new);
    public static final Factory Z064 = new Factory(MathType.Z064, BufferZ064::new);
    @Deprecated
    public static final Factory DIRECT32 = R032;
    @Deprecated
    public static final Factory DIRECT64 = R064;
    private final Buffer myBuffer;
    private final AutoCloseable myFile;

    @Deprecated
    public static Array1D<Double> make(File file, long count) {
        return R064.newMapped(file).make(count).wrapInArray1D();
    }

    @Deprecated
    public static ArrayAnyD<Double> make(File file, long ... structure) {
        return R064.newMapped(file).make(StructureAnyD.count(structure)).wrapInArrayAnyD(structure);
    }

    @Deprecated
    public static Array2D<Double> make(File file, long rows, long columns) {
        return R064.newMapped(file).make(rows * columns).wrapInArray2D(rows);
    }

    @Deprecated
    public static DenseArray<Double> make(int capacity) {
        return (DenseArray)R064.make(capacity);
    }

    @Deprecated
    public static BufferArray wrap(ByteBuffer data) {
        return new BufferR064(R064, data, null);
    }

    BufferArray(Factory factory, Buffer buffer, AutoCloseable file) {
        super(factory, buffer.capacity());
        this.myBuffer = buffer;
        this.myFile = file;
    }

    @Override
    public void close() {
        if (this.myFile != null) {
            try {
                this.myFile.close();
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
        }
    }

    @Override
    public void reset() {
        this.fillAll(PrimitiveMath.ZERO);
        this.myBuffer.clear();
    }

    @Override
    protected final void add(int index, double addend) {
        this.set(index, this.doubleValue(index) + addend);
    }

    @Override
    protected final void add(int index, float addend) {
        this.set(index, this.floatValue(index) + addend);
    }

    @Override
    protected final void add(int index, long addend) {
        this.set(index, this.longValue(index) + addend);
    }

    @Override
    protected final void add(int index, int addend) {
        this.set(index, this.intValue(index) + addend);
    }

    @Override
    protected final void add(int index, short addend) {
        this.set(index, this.shortValue(index) + addend);
    }

    @Override
    protected final void add(int index, byte addend) {
        this.set(index, this.byteValue(index) + addend);
    }

    @Override
    protected void exchange(int firstA, int firstB, int step, int count) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < count; ++i) {
            double tmpVal = this.doubleValue(tmpIndexA);
            this.set(tmpIndexA, this.doubleValue(tmpIndexB));
            this.set(tmpIndexB, tmpVal);
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    @Override
    protected void fill(int first, int limit, int step, Double value) {
        FillAll.fill(this, (long)first, (long)limit, (long)step, value);
    }

    @Override
    protected void fill(int first, int limit, int step, NullaryFunction<?> supplier) {
        FillAll.fill(this, (long)first, (long)limit, (long)step, supplier);
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.set(index, values.doubleValue(valueIndex));
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.set(index, (Comparable<?>)value);
    }

    @Override
    protected Double get(int index) {
        return this.doubleValue(index);
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke(this, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.doubleValue(index));
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.doubleValue(index));
    }

    @Override
    protected void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        OperationBinary.invoke(this, (long)first, (long)limit, (long)step, left, function, this);
    }

    @Override
    protected void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        OperationBinary.invoke(this, (long)first, (long)limit, (long)step, this, function, right);
    }

    @Override
    protected void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        OperationUnary.invoke(this, (long)first, (long)limit, (long)step, this, function);
    }

    @Override
    protected void modifyOne(int index, UnaryFunction<Double> modifier) {
        this.set(index, modifier.invoke(this.doubleValue(index)));
    }

    @Override
    protected int searchAscending(Double number) {
        return -1;
    }

    @Override
    protected void set(int index, Comparable<?> value) {
        this.set(index, NumberDefinition.doubleValue(value));
    }

    @Override
    protected void sortAscending() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    protected void sortDescending() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    protected void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        OperationVoid.invoke(this, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.doubleValue(index));
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.set(intIndex, function.invoke(left.doubleValue(extIndex), this.doubleValue(intIndex)));
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.set(intIndex, function.invoke(this.doubleValue(intIndex), right.doubleValue(extIndex)));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.set(intIndex, function.invoke(this.doubleValue(intIndex)));
    }

    @FunctionalInterface
    static interface BufferConstructor {
        public BufferArray newInstance(Factory var1, ByteBuffer var2, AutoCloseable var3);
    }

    public static final class MappedFileFactory
    extends DenseArray.Factory<Double> {
        private final File myFile;
        private final Factory myTypeFactory;

        MappedFileFactory(Factory typeFactory, File file) {
            this.myTypeFactory = typeFactory;
            this.myFile = file;
        }

        @Override
        public FunctionSet<Double> function() {
            return this.myTypeFactory.function();
        }

        @Override
        public BufferArray makeFilled(Structure1D shape, NullaryFunction<?> supplier) {
            return (BufferArray)super.makeFilled(shape, supplier);
        }

        @Override
        public BufferArray copy(Access1D<?> source) {
            return (BufferArray)super.copy((Access1D)source);
        }

        @Override
        public BufferArray copy(Comparable<?> ... source) {
            return (BufferArray)super.copy((Comparable[])source);
        }

        @Override
        public BufferArray copy(double ... source) {
            return (BufferArray)super.copy(source);
        }

        @Override
        public BufferArray copy(List<? extends Comparable<?>> source) {
            return (BufferArray)super.copy((List)source);
        }

        @Override
        public BufferArray make(long count) {
            return (BufferArray)super.make(count);
        }

        @Override
        SegmentedArray<Double> makeSegmented(long ... structure) {
            return super.makeSegmented(structure);
        }

        @Override
        public BufferArray make(int count) {
            return (BufferArray)super.make(count);
        }

        @Override
        public BufferArray make(Structure1D shape) {
            return (BufferArray)super.make(shape);
        }

        @Override
        public BufferArray makeFilled(long count, NullaryFunction<?> supplier) {
            return (BufferArray)super.makeFilled(count, (NullaryFunction)supplier);
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return this.myTypeFactory.scalar();
        }

        @Override
        AggregatorSet<Double> aggregator() {
            return this.myTypeFactory.aggregator();
        }

        BufferArray makeDenseArray(long size) {
            MappedByteBuffer buffer;
            FileChannel fileChannel;
            long count = this.myTypeFactory.getElementSize() * size;
            try {
                fileChannel = new RandomAccessFile(this.myFile, "rw").getChannel();
                buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, count);
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
            return this.myTypeFactory.newInstance(this.myTypeFactory, buffer, fileChannel);
        }

        @Override
        public MathType getMathType() {
            return this.myTypeFactory.getMathType();
        }
    }

    public static final class Factory
    extends DenseArray.Factory<Double> {
        private final BufferConstructor myConstructor;
        private final MathType myMathType;

        Factory(MathType mathType, BufferConstructor constructor) {
            this.myMathType = mathType;
            this.myConstructor = constructor;
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        public MappedFileFactory newMapped(File file) {
            return new MappedFileFactory(this, file);
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        long getCapacityLimit() {
            return 0x7FFFFFF7L / this.getElementSize();
        }

        BufferArray makeDenseArray(long size) {
            int capacity = Math.toIntExact(size * this.getElementSize());
            ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
            return this.myConstructor.newInstance(this, buffer, null);
        }

        BufferArray newInstance(Factory factory, ByteBuffer buffer, AutoCloseable closeable) {
            return this.myConstructor.newInstance(factory, buffer, closeable);
        }

        @Override
        public MathType getMathType() {
            return this.myMathType;
        }
    }
}

