/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.LowerUpper;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.TypeUtils;

abstract class OptimisedPortfolio
extends EquilibriumModel {
    static final String BALANCE = "Balance";
    static final String VARIANCE = "Variance";
    private final MatrixR064 myExpectedExcessReturns;
    private final Optimisation.Options myOptimisationOptions = new Optimisation.Options();
    private transient Optimisation.State myOptimisationState = Optimisation.State.UNEXPLORED;
    private boolean myShortingAllowed = false;
    private final Variable[] myVariables;

    OptimisedPortfolio(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
        this.myExpectedExcessReturns = portfolioContext.getAssetReturns();
        String[] tmpSymbols = this.getMarketEquilibrium().getAssetKeys();
        this.myVariables = new Variable[tmpSymbols.length];
        for (int i = 0; i < tmpSymbols.length; ++i) {
            this.myVariables[i] = new Variable(tmpSymbols[i]);
            this.myVariables[i].weight(TypeUtils.toBigDecimal(this.myExpectedExcessReturns.get(i)).negate());
        }
        this.myOptimisationOptions.solution = this.myOptimisationOptions.solution.withPrecision(7).withScale(6);
    }

    OptimisedPortfolio(MarketEquilibrium marketEquilibrium, MatrixR064 expectedExcessReturns) {
        super(marketEquilibrium);
        if (marketEquilibrium.size() != (int)expectedExcessReturns.count()) {
            throw new IllegalArgumentException("Wrong dimensions!");
        }
        this.myExpectedExcessReturns = expectedExcessReturns;
        String[] tmpSymbols = this.getMarketEquilibrium().getAssetKeys();
        this.myVariables = new Variable[tmpSymbols.length];
        for (int i = 0; i < tmpSymbols.length; ++i) {
            this.myVariables[i] = new Variable(tmpSymbols[i]);
            this.myVariables[i].weight(TypeUtils.toBigDecimal(expectedExcessReturns.get(i)).negate());
        }
        this.myOptimisationOptions.solution = this.myOptimisationOptions.solution.withPrecision(7).withScale(6);
    }

    OptimisedPortfolio(MatrixR064 covarianceMatrix, MatrixR064 expectedExcessReturns) {
        this(new MarketEquilibrium(covarianceMatrix), expectedExcessReturns);
    }

    public final boolean isShortingAllowed() {
        return this.myShortingAllowed;
    }

    public Optimiser optimiser() {
        return new Optimiser();
    }

    public final void setShortingAllowed(boolean allowed) {
        this.myShortingAllowed = allowed;
        this.reset();
    }

    @Override
    protected final MatrixR064 calculateAssetReturns() {
        return this.myExpectedExcessReturns;
    }

    protected final MatrixR064 handle(Optimisation.Result optimisationResult) {
        int tmpLength = this.myVariables.length;
        this.myOptimisationState = optimisationResult.getState();
        boolean tmpFeasible = optimisationResult.getState().isFeasible();
        boolean tmpShortingAllowed = this.isShortingAllowed();
        MatrixR064.DenseReceiver tmpMtrxBuilder = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            BigDecimal tmpValue = tmpFeasible ? (tmpShortingAllowed ? optimisationResult.get(i) : optimisationResult.get(i).max(BigMath.ZERO)) : BigMath.ZERO;
            this.myVariables[i].setValue(tmpValue);
            tmpMtrxBuilder.set((long)i, (Comparable)tmpValue);
        }
        return (MatrixR064)tmpMtrxBuilder.get();
    }

    @Override
    protected void reset() {
        super.reset();
        this.myOptimisationState = Optimisation.State.UNEXPLORED;
    }

    final Optimisation.Options getOptimisationOptions() {
        return this.myOptimisationOptions;
    }

    Variable getVariable(int index) {
        return this.myVariables[index];
    }

    final ExpressionsBasedModel makeModel(Map<int[], LowerUpper> constraints) {
        int i;
        int tmpLength = this.myVariables.length;
        Variable[] tmpVariables = new Variable[tmpLength];
        for (int i2 = 0; i2 < tmpVariables.length; ++i2) {
            tmpVariables[i2] = this.myVariables[i2].copy();
            if (this.isShortingAllowed() || this.myVariables[i2].getLowerLimit() != null && this.myVariables[i2].getLowerLimit().signum() != -1) continue;
            tmpVariables[i2].lower((Comparable)BigMath.ZERO);
        }
        ExpressionsBasedModel retVal = new ExpressionsBasedModel(this.myOptimisationOptions);
        retVal.addVariables(tmpVariables);
        Expression myOptimisationVariance = retVal.newExpression(VARIANCE);
        MatrixR064 tmpCovariances = this.getCovariances();
        for (int j = 0; j < tmpLength; ++j) {
            for (i = 0; i < tmpLength; ++i) {
                myOptimisationVariance.set(i, j, (Comparable<?>)tmpCovariances.get(i, j));
            }
        }
        Expression tmpBalanceExpression = retVal.newExpression(BALANCE);
        for (i = 0; i < tmpLength; ++i) {
            tmpBalanceExpression.set(i, BigMath.ONE);
        }
        tmpBalanceExpression.level(BigMath.ONE);
        for (Map.Entry<int[], LowerUpper> tmpEntry : constraints.entrySet()) {
            int[] tmpKey = tmpEntry.getKey();
            LowerUpper tmpValue = tmpEntry.getValue();
            Expression tmpExpression = retVal.newExpression(Arrays.toString(tmpKey));
            for (int i3 = 0; i3 < tmpKey.length; ++i3) {
                tmpExpression.set(tmpKey[i3], BigMath.ONE);
            }
            ((Expression)tmpExpression.lower(tmpValue.lower)).upper(tmpValue.upper);
        }
        return retVal;
    }

    public final class Optimiser {
        public Optimiser debug(boolean debug) {
            boolean tmpValidate = OptimisedPortfolio.this.myOptimisationOptions.validate;
            if (debug) {
                OptimisedPortfolio.this.myOptimisationOptions.debug(Optimisation.Solver.class);
            } else {
                OptimisedPortfolio.this.myOptimisationOptions.debug(null);
            }
            OptimisedPortfolio.this.myOptimisationOptions.validate = tmpValidate;
            return this;
        }

        public Optimiser feasibility(int scale) {
            OptimisedPortfolio.this.myOptimisationOptions.feasibility = OptimisedPortfolio.this.myOptimisationOptions.feasibility.withScale(scale);
            return this;
        }

        public Optimisation.State getState() {
            if (OptimisedPortfolio.this.myOptimisationState == null) {
                OptimisedPortfolio.this.myOptimisationState = Optimisation.State.UNEXPLORED;
            }
            return OptimisedPortfolio.this.myOptimisationState;
        }

        public Optimiser time(CalendarDateDuration max) {
            long maxDurationInMillis;
            OptimisedPortfolio.this.myOptimisationOptions.time_abort = maxDurationInMillis = max.toDurationInMillis();
            OptimisedPortfolio.this.myOptimisationOptions.time_suffice = maxDurationInMillis;
            return this;
        }

        public Optimiser validate(boolean validate) {
            OptimisedPortfolio.this.myOptimisationOptions.validate = validate;
            return this;
        }
    }
}

