/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.AccessScalar;

public interface AggregatorFunction<N extends Comparable<N>>
extends VoidFunction<N>,
AccessScalar<N> {
    default public AggregatorFunction<N> filter(PredicateFunction<N> predicate) {
        return new PredicateWrapper<N>(predicate, this);
    }

    public AggregatorFunction<N> reset();

    @Deprecated
    public Scalar<N> toScalar();

    public static final class PredicateWrapper<N extends Comparable<N>>
    implements AggregatorFunction<N> {
        private final AggregatorFunction<N> myAggregator;
        private final PredicateFunction<N> myPredicate;

        PredicateWrapper(PredicateFunction<N> predicate, AggregatorFunction<N> aggregator) {
            this.myPredicate = predicate;
            this.myAggregator = aggregator;
        }

        @Override
        public boolean booleanValue() {
            return this.myAggregator.booleanValue();
        }

        @Override
        public byte byteValue() {
            return this.myAggregator.byteValue();
        }

        @Override
        public double doubleValue() {
            return this.myAggregator.doubleValue();
        }

        @Override
        public float floatValue() {
            return this.myAggregator.floatValue();
        }

        @Override
        public N get() {
            return (N)((Comparable)this.myAggregator.get());
        }

        @Override
        public int intValue() {
            return this.myAggregator.intValue();
        }

        @Override
        public void invoke(byte arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public void invoke(double arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public void invoke(float arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public void invoke(int arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public void invoke(long arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public void invoke(N arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public void invoke(short arg) {
            if (this.myPredicate.test(arg)) {
                this.myAggregator.invoke(arg);
            }
        }

        @Override
        public long longValue() {
            return this.myAggregator.longValue();
        }

        @Override
        public AggregatorFunction<N> reset() {
            return this.myAggregator.reset();
        }

        @Override
        public short shortValue() {
            return this.myAggregator.shortValue();
        }

        @Override
        public Scalar<N> toScalar() {
            return this.myAggregator.toScalar();
        }
    }
}

