/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.ConstantFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public final class AffineFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Affine<N> {
    private final MatrixStore<N> myCoefficients;
    private final ConstantFunction<N> myConstant;

    public static <N extends Comparable<N>> Factory<N> factory(PhysicalStore.Factory<N, ?> factory) {
        return new Factory<N>(factory);
    }

    @Deprecated
    public static AffineFunction<ComplexNumber> makeComplex(Access1D<?> coefficients) {
        return AffineFunction.factory(GenericStore.C128).coefficients(coefficients).make(coefficients.size());
    }

    @Deprecated
    public static AffineFunction<ComplexNumber> makeComplex(int arity) {
        return AffineFunction.factory(GenericStore.C128).make(arity);
    }

    @Deprecated
    public static AffineFunction<Double> makePrimitive(Access1D<?> coefficients) {
        return AffineFunction.factory(Primitive64Store.FACTORY).coefficients(coefficients).make(coefficients.size());
    }

    @Deprecated
    public static AffineFunction<Double> makePrimitive(int arity) {
        return AffineFunction.factory(Primitive64Store.FACTORY).make(arity);
    }

    @Deprecated
    public static AffineFunction<RationalNumber> makeRational(Access1D<?> coefficients) {
        return AffineFunction.factory(GenericStore.Q128).coefficients(coefficients).make(coefficients.size());
    }

    @Deprecated
    public static AffineFunction<RationalNumber> makeRational(int arity) {
        return AffineFunction.factory(GenericStore.Q128).make(arity);
    }

    public static <N extends Comparable<N>> AffineFunction<N> wrap(PhysicalStore<N> coefficients) {
        return new AffineFunction<N>(coefficients);
    }

    AffineFunction(MatrixStore<N> coefficients) {
        if (!coefficients.isVector()) {
            throw new IllegalArgumentException("Must be a  vector!");
        }
        this.myCoefficients = coefficients;
        this.myConstant = new ConstantFunction<N>(coefficients.count(), coefficients.physical());
    }

    @Override
    public int arity() {
        return Math.toIntExact(this.myCoefficients.count());
    }

    @Override
    public N getConstant() {
        return this.myConstant.getConstant();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.getLinearFactors(false);
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myCoefficients.physical().makeZero(this.arity(), this.arity());
    }

    @Override
    public MatrixStore<N> getLinearFactors(boolean negated) {
        Object retVal = this.myCoefficients;
        if (this.myCoefficients.countRows() == 1L) {
            retVal = retVal.transpose();
        }
        if (negated) {
            retVal = retVal.negate();
        }
        return retVal;
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return (N)((Comparable)this.getScalarValue(arg).get());
    }

    @Override
    public PhysicalStore<N> linear() {
        return (PhysicalStore)this.myCoefficients;
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myConstant.setConstant(constant);
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myCoefficients.physical();
    }

    Scalar<N> getScalarValue(Access1D<N> arg) {
        PhysicalStore preallocated = (PhysicalStore)this.myCoefficients.physical().make(1L, 1L);
        Scalar<N> retVal = this.myConstant.getScalarConstant();
        this.myCoefficients.multiply(arg, preallocated);
        return (Scalar)retVal.add(preallocated.get(0L, 0L));
    }

    public static final class Factory<N extends Comparable<N>> {
        private Access1D<?> myCoefficients = null;
        private final PhysicalStore.Factory<N, ?> myFactory;

        Factory(PhysicalStore.Factory<N, ?> factory) {
            this.myFactory = factory;
        }

        public Factory<N> coefficients(Access1D<?> coefficients) {
            this.myCoefficients = coefficients;
            return this;
        }

        public AffineFunction<N> make(int arity) {
            if (this.myCoefficients != null) {
                return new AffineFunction((MatrixStore)this.myFactory.rows(this.myCoefficients));
            }
            return new AffineFunction((MatrixStore)this.myFactory.make(1, arity));
        }
    }
}

