/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public final class ConstantFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Constant<N> {
    private final int myArity;
    private Scalar<N> myConstant = null;
    private final PhysicalStore.Factory<N, ?> myFactory;

    public static <N extends Comparable<N>> Factory<N> factory(PhysicalStore.Factory<N, ?> factory) {
        return new Factory<N>(factory);
    }

    @Deprecated
    public static ConstantFunction<ComplexNumber> makeComplex(int arity) {
        return ConstantFunction.factory(GenericStore.C128).make(arity);
    }

    @Deprecated
    public static ConstantFunction<ComplexNumber> makeComplex(int arity, Comparable<?> constant) {
        return ConstantFunction.factory(GenericStore.C128).constant(constant).make(arity);
    }

    @Deprecated
    public static ConstantFunction<Double> makePrimitive(int arity) {
        return ConstantFunction.factory(Primitive64Store.FACTORY).make(arity);
    }

    @Deprecated
    public static ConstantFunction<Double> makePrimitive(int arity, Comparable<?> constant) {
        return ConstantFunction.factory(Primitive64Store.FACTORY).constant(constant).make(arity);
    }

    @Deprecated
    public static ConstantFunction<RationalNumber> makeRational(int arity) {
        return ConstantFunction.factory(GenericStore.Q128).make(arity);
    }

    @Deprecated
    public static ConstantFunction<RationalNumber> makeRational(int arity, Comparable<?> constant) {
        return ConstantFunction.factory(GenericStore.Q128).constant(constant).make(arity);
    }

    ConstantFunction(int arity, PhysicalStore.Factory<N, ?> factory, Comparable<?> constant) {
        this(arity, factory);
        this.setConstant(constant);
    }

    ConstantFunction(long arity, PhysicalStore.Factory<N, ?> factory) {
        this.myArity = Math.toIntExact(arity);
        this.myFactory = factory;
    }

    @Override
    public int arity() {
        return this.myArity;
    }

    @Override
    public N getConstant() {
        return (N)((Comparable)this.getScalarConstant().get());
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.getLinearFactors(false);
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myFactory.makeZero(this.myArity, this.myArity);
    }

    @Override
    public MatrixStore<N> getLinearFactors(boolean negated) {
        return this.myFactory.makeZero(this.myArity, 1L);
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return this.getConstant();
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myConstant = constant != null ? this.myFactory.scalar().convert(constant) : null;
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myFactory;
    }

    Scalar<N> getScalarConstant() {
        return this.myConstant != null ? this.myConstant : this.myFactory.scalar().zero();
    }

    public static final class Factory<N extends Comparable<N>> {
        private Comparable<?> myConstant = null;
        private final PhysicalStore.Factory<N, ?> myFactory;

        Factory(PhysicalStore.Factory<N, ?> factory) {
            this.myFactory = factory;
        }

        public Factory<N> constant(Comparable<?> constant) {
            this.myConstant = constant;
            return this;
        }

        public ConstantFunction<N> make(int arity) {
            return new ConstantFunction<N>(arity, this.myFactory, this.myConstant);
        }
    }
}

