/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access1D;

public class PolynomialC128
extends AbstractPolynomial<ComplexNumber> {
    public PolynomialC128(int degree) {
        super((Array1D)Array1D.C128.make(degree + 1));
    }

    PolynomialC128(Array1D<ComplexNumber> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, GenericStore.C128, QR.C128);
    }

    @Override
    public ComplexNumber integrate(ComplexNumber fromPoint, ComplexNumber toPoint) {
        PolynomialFunction primitive = this.buildPrimitive();
        ComplexNumber fromVal = primitive.invoke(fromPoint);
        ComplexNumber toVal = primitive.invoke(toPoint);
        return toVal.subtract(fromVal);
    }

    @Override
    public ComplexNumber invoke(ComplexNumber arg) {
        int power = this.degree();
        ComplexNumber retVal = (ComplexNumber)this.get(power);
        while (--power >= 0) {
            retVal = ((ComplexNumber)this.get(power)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int limit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < limit; ++p) {
            this.set(p, ComplexNumber.valueOf(coefficients.get(p)));
        }
    }

    @Override
    protected ComplexNumber getDerivativeFactor(int power) {
        int nextIndex = power + 1;
        return (ComplexNumber)((ComplexNumber)this.get(nextIndex)).multiply(nextIndex);
    }

    @Override
    protected ComplexNumber getPrimitiveFactor(int power) {
        if (power <= 0) {
            return ComplexNumber.ZERO;
        }
        return (ComplexNumber)((ComplexNumber)this.get(power - 1)).divide(power);
    }

    @Override
    protected AbstractPolynomial<ComplexNumber> makeInstance(int size) {
        return new PolynomialC128((Array1D)Array1D.C128.make(size));
    }
}

