/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.special;

import org.ojalgo.function.constant.ComplexMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.ComplexNumber;

public abstract class GammaFunction {
    public static ComplexNumber gamma(ComplexNumber z) {
        return LanczosApproximation.gamma(z);
    }

    public static double gamma(double x) {
        return LanczosApproximation.gamma(x);
    }

    public static double gamma(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        return MissingMath.factorial(n - 1);
    }

    static abstract class LanczosApproximation {
        private static final double A = PrimitiveMath.SEVEN;
        private static final double[] C = new double[]{0.9999999999998099, 676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};
        private static final double LOG_SQRT_TWO_PI = PrimitiveMath.LOG.invoke(PrimitiveMath.SQRT_TWO_PI);

        LanczosApproximation() {
        }

        static ComplexNumber gamma(ComplexNumber z) {
            double zr = z.getReal();
            if (zr <= PrimitiveMath.ZERO && PrimitiveMath.ABS.invoke(zr % PrimitiveMath.ONE) < PrimitiveMath.MACHINE_EPSILON) {
                return ComplexNumber.NaN;
            }
            if (zr < PrimitiveMath.HALF) {
                return ComplexMath.SIN.invoke(z.multiply(PrimitiveMath.PI)).multiply(GammaFunction.gamma(ComplexNumber.ONE.subtract(z))).invert().multiply(PrimitiveMath.PI);
            }
            ComplexNumber z1 = z.subtract(PrimitiveMath.ONE);
            ComplexNumber za = z1.add(A + PrimitiveMath.HALF);
            ComplexNumber zs = ComplexNumber.valueOf(C[0]);
            for (int i = C.length - 1; i > 0; --i) {
                zs = zs.add(((ComplexNumber)z1.add(i)).invert().multiply(C[i]));
            }
            return ComplexMath.POW.invoke(za, z1.add(PrimitiveMath.HALF)).multiply(PrimitiveMath.SQRT_TWO_PI).multiply(ComplexMath.EXP.invoke(za.negate())).multiply(zs);
        }

        static double gamma(double x) {
            if (x <= PrimitiveMath.ZERO && PrimitiveMath.ABS.invoke(x % PrimitiveMath.ONE) < PrimitiveMath.MACHINE_EPSILON) {
                return Double.NaN;
            }
            if (x < PrimitiveMath.HALF) {
                return PrimitiveMath.PI / (PrimitiveMath.SIN.invoke(PrimitiveMath.PI * x) * GammaFunction.gamma(PrimitiveMath.ONE - x));
            }
            double x1 = x - PrimitiveMath.ONE;
            double xa = x1 + (A + PrimitiveMath.HALF);
            double xs = C[0];
            for (int i = C.length - 1; i > 0; --i) {
                xs += C[i] / (x1 + (double)i);
            }
            return PrimitiveMath.POW.invoke(xa, x1 + PrimitiveMath.HALF) * PrimitiveMath.SQRT_TWO_PI * PrimitiveMath.EXP.invoke(-xa) * xs;
        }

        static ComplexNumber logarithmic(ComplexNumber z) {
            ComplexNumber z1 = z.subtract(PrimitiveMath.ONE);
            ComplexNumber za = z1.add(A + PrimitiveMath.HALF);
            ComplexNumber zs = ComplexNumber.valueOf(C[0]);
            for (int i = C.length - 1; i > 0; --i) {
                zs = zs.add(((ComplexNumber)z1.add(i)).invert().multiply(C[i]));
            }
            return z1.add(PrimitiveMath.HALF).multiply(ComplexMath.LOG.invoke(za)).add(LOG_SQRT_TWO_PI).subtract(za).add(ComplexMath.LOG.invoke(zs));
        }

        static double logarithmic(double x) {
            double x1 = x - PrimitiveMath.ONE;
            double xa = x1 + (A + PrimitiveMath.HALF);
            double xs = C[0];
            for (int i = C.length - 1; i > 0; --i) {
                xs += C[i] / (x1 + (double)i);
            }
            return (x1 + PrimitiveMath.HALF) * PrimitiveMath.LOG.invoke(xa) + LOG_SQRT_TWO_PI - xa + PrimitiveMath.LOG.invoke(xs);
        }
    }

    public static abstract class Regularized
    extends GammaFunction {
        public static ComplexNumber lower(ComplexNumber z, double limit) {
            return Incomplete.lower(z, limit).divide(GammaFunction.gamma(z));
        }

        public static double lower(double x, double limit) {
            return Incomplete.lower(x, limit) / GammaFunction.gamma(x);
        }

        public static double lower(int n, double limit) {
            return Incomplete.lower(n, limit) / GammaFunction.gamma(n);
        }

        public static ComplexNumber upper(ComplexNumber z, double limit) {
            return Incomplete.upper(z, limit).divide(GammaFunction.gamma(z));
        }

        public static double upper(double x, double limit) {
            return Incomplete.upper(x, limit) / GammaFunction.gamma(x);
        }

        public static double upper(int n, double limit) {
            return Incomplete.upper(n, limit) / GammaFunction.gamma(n);
        }
    }

    public static abstract class Logarithmic
    extends GammaFunction {
        public static ComplexNumber gamma(ComplexNumber z) {
            return LanczosApproximation.logarithmic(z);
        }

        public static double gamma(double x) {
            return LanczosApproximation.logarithmic(x);
        }

        public static double gamma(int n) {
            return Math.log(GammaFunction.gamma(n));
        }
    }

    public static abstract class Incomplete
    extends GammaFunction {
        public static ComplexNumber lower(ComplexNumber z, double limit) {
            return ComplexNumber.NaN;
        }

        public static double lower(double x, double limit) {
            double base = Math.exp(-limit) * Math.pow(limit, x);
            if (Math.abs(base) < PrimitiveMath.MACHINE_EPSILON) {
                return PrimitiveMath.ZERO;
            }
            double numerator = PrimitiveMath.ONE;
            double denominator = x;
            double sum = numerator / denominator;
            for (int i = 1; i < 100; ++i) {
                sum += (numerator *= limit) / (denominator *= x + (double)i);
            }
            return base * sum;
        }

        public static double lower(int n, double limit) {
            double incr = PrimitiveMath.ONE;
            double sum = PrimitiveMath.ONE;
            for (int k = 1; k < n; ++k) {
                sum += (incr *= limit / (double)k);
            }
            return (PrimitiveMath.ONE - sum * Math.exp(-limit)) * MissingMath.factorial(n - 1);
        }

        public static ComplexNumber upper(ComplexNumber z, double limit) {
            return ComplexNumber.NaN;
        }

        public static double upper(double x, double limit) {
            return GammaFunction.gamma(x) - Incomplete.lower(x, limit);
        }

        public static double upper(int n, double limit) {
            double incr = PrimitiveMath.ONE;
            double sum = PrimitiveMath.ONE;
            for (int k = 1; k < n; ++k) {
                sum += (incr *= limit / (double)k);
            }
            return sum * Math.exp(-limit) * MissingMath.factorial(n - 1);
        }
    }
}

