/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import org.ojalgo.machine.BasicMachine;
import org.ojalgo.machine.Hardware;
import org.ojalgo.machine.VirtualMachine;
import org.ojalgo.type.IntCount;

public abstract class CommonMachine
extends BasicMachine {
    static final long K = 1024L;
    public final String architecture;
    public final long cache;
    public final int cores;
    public final int units;

    static long elements(long availableMemory, long elementSize) {
        return availableMemory / elementSize;
    }

    protected CommonMachine(Hardware hardware, Runtime runtime) {
        super(Math.min(hardware.memory, runtime.maxMemory()), Math.min(hardware.threads, runtime.availableProcessors()));
        this.architecture = hardware.architecture;
        this.cache = hardware.cache;
        this.cores = hardware.cores;
        this.units = hardware.units;
    }

    protected CommonMachine(String arch, BasicMachine[] levels) {
        super(levels[0].memory, levels[0].threads);
        this.architecture = arch;
        this.cores = this.threads / levels[levels.length - 1].threads;
        this.cache = levels[1].memory;
        this.units = this.threads / levels[1].threads;
    }

    CommonMachine(VirtualMachine base, int modUnits, int modCores, int modThreads) {
        super(base.memory, modThreads);
        this.architecture = base.architecture;
        this.cache = base.cache;
        this.cores = modCores;
        this.units = modUnits;
    }

    @Deprecated
    public final IntCount countCores() {
        return new IntCount(this.cores);
    }

    @Deprecated
    public final IntCount countThreads() {
        return new IntCount(this.threads);
    }

    @Deprecated
    public final IntCount countUnits() {
        return new IntCount(this.units);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof CommonMachine)) {
            return false;
        }
        CommonMachine other = (CommonMachine)obj;
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
            return false;
        }
        return this.cache == other.cache && this.cores == other.cores && this.units == other.units;
    }

    @Deprecated
    public final long getCacheElements(long elementSize) {
        return CommonMachine.elements(this.cache, elementSize);
    }

    @Deprecated
    public final long getMemoryElements(long elementSize) {
        return CommonMachine.elements(this.memory, elementSize);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
        result = 31 * result + (int)(this.cache ^ this.cache >>> 32);
        result = 31 * result + this.cores;
        return 31 * result + this.units;
    }

    public final boolean isMultiCore() {
        return this.cores > 1;
    }

    public final boolean isMultiThread() {
        return this.threads > 1;
    }

    public final boolean isMultiUnit() {
        return this.units > 1;
    }
}

