/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.QRDecomposition;
import org.ojalgo.matrix.decomposition.RawQR;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public interface QR<N extends Comparable<N>>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.Determinant<N>,
MatrixDecomposition.RankRevealing<N> {
    public static final Factory<ComplexNumber> C128 = (typical, fullSize) -> new QRDecomposition.C128(fullSize);
    public static final Factory<Double> R064 = (typical, fullSize) -> {
        if (fullSize || typical.isFat() || 64L >= typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new QRDecomposition.R064(fullSize);
        }
        return new RawQR();
    };
    public static final Factory<Quadruple> R128 = (typical, fullSize) -> new QRDecomposition.R128(fullSize);
    public static final Factory<Quaternion> H256 = (typical, fullSize) -> new QRDecomposition.H256(fullSize);
    public static final Factory<RationalNumber> Q128 = (typical, fullSize) -> new QRDecomposition.Q128(fullSize);
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    @Deprecated
    public static final Factory<Quadruple> QUADRUPLE = R128;
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, QR<N> decomposition, NumberContext context) {
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        MatrixStore<N> tmpR = decomposition.getR();
        MatrixStore<MatrixStore<N>> tmpStore = tmpQ.multiply(tmpR);
        return Access2D.equals(tmpStore, matrix, context);
    }

    public MatrixStore<N> getQ();

    public MatrixStore<N> getR();

    @Override
    default public boolean isOrdered() {
        return false;
    }

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxQ = this.getQ();
        MatrixStore<N> mtrxR = this.getR();
        return mtrxQ.multiply(mtrxR);
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<QR<N>> {
        default public QR<N> make(boolean fullSize) {
            return this.make(MatrixDecomposition.TYPICAL, fullSize);
        }

        @Override
        default public QR<N> make(Structure2D typical) {
            return this.make(typical, false);
        }

        public QR<N> make(Structure2D var1, boolean var2);
    }
}

