/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public final class DiagonalStore<N extends Comparable<N>, D extends Access1D<?>>
extends FactoryStore<N> {
    private final D myMainDiagonal;
    private final Scalar.Factory<N> myScalarFactory;
    private final D mySubdiagonal;
    private final D mySuperdiagonal;
    private final N myZero;

    public static <N extends Comparable<N>, D extends Access1D<?>> Builder<N, D> builder(PhysicalStore.Factory<N, ?> factory, D mainDiagonal) {
        return new Builder<N, D>(factory, mainDiagonal);
    }

    DiagonalStore(PhysicalStore.Factory<N, ?> factory, long numberOfRows, long numberOfColumns, D mainDiag, D superdiag, D subdiag) {
        super(factory, numberOfRows, numberOfColumns);
        this.myMainDiagonal = mainDiag;
        this.mySuperdiagonal = superdiag;
        this.mySubdiagonal = subdiag;
        this.myScalarFactory = factory.scalar();
        this.myZero = (Comparable)factory.scalar().zero().get();
    }

    @Override
    public double doubleValue(long row, long col) {
        if (this.myMainDiagonal != null && row == col) {
            return this.myMainDiagonal.doubleValue(row);
        }
        if (this.mySuperdiagonal != null && col - row == 1L) {
            return this.mySuperdiagonal.doubleValue(row);
        }
        if (this.mySubdiagonal != null && row - col == 1L) {
            return this.mySubdiagonal.doubleValue(col);
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        if (this.mySuperdiagonal != null) {
            return col - 1;
        }
        if (this.myMainDiagonal != null) {
            return col;
        }
        if (this.mySubdiagonal != null) {
            return col + 1;
        }
        return this.getRowDim();
    }

    @Override
    public int firstInRow(int row) {
        if (this.mySubdiagonal != null) {
            return row - 1;
        }
        if (this.myMainDiagonal != null) {
            return row;
        }
        if (this.mySuperdiagonal != null) {
            return row + 1;
        }
        return this.getColDim();
    }

    @Override
    public N get(long row, long col) {
        if (this.myMainDiagonal != null && row == col) {
            return this.myScalarFactory.cast((Comparable<?>)this.myMainDiagonal.get(row));
        }
        if (this.mySuperdiagonal != null && col - row == 1L) {
            return this.myScalarFactory.cast((Comparable<?>)this.mySuperdiagonal.get(row));
        }
        if (this.mySubdiagonal != null && row - col == 1L) {
            return this.myScalarFactory.cast((Comparable<?>)this.mySubdiagonal.get(col));
        }
        return this.myZero;
    }

    public int getDimension() {
        return MissingMath.toMinIntExact(this.countRows(), this.countColumns());
    }

    public Optional<D> getMainDiagonal() {
        return Optional.ofNullable(this.myMainDiagonal);
    }

    public Optional<D> getSubdiagonal() {
        return Optional.ofNullable(this.mySubdiagonal);
    }

    public Optional<D> getSuperdiagonal() {
        return Optional.ofNullable(this.mySuperdiagonal);
    }

    @Override
    public int limitOfColumn(int col) {
        if (this.mySubdiagonal != null) {
            return Math.min(col + 2, this.getRowDim());
        }
        if (this.myMainDiagonal != null) {
            return Math.min(col + 1, this.getRowDim());
        }
        if (this.mySuperdiagonal != null) {
            return Math.min(col, this.getRowDim());
        }
        return 0;
    }

    @Override
    public int limitOfRow(int row) {
        if (this.mySuperdiagonal != null) {
            return Math.min(row + 2, this.getColDim());
        }
        if (this.myMainDiagonal != null) {
            return Math.min(row + 1, this.getColDim());
        }
        if (this.mySubdiagonal != null) {
            return Math.min(row, this.getColDim());
        }
        return 0;
    }

    public void supplyMainDiagonalTo(double[] receiver) {
        if (this.myMainDiagonal != null) {
            this.myMainDiagonal.supplyTo(receiver);
        } else {
            Arrays.fill(receiver, PrimitiveMath.ZERO);
        }
    }

    public void supplySubdiagonalTo(double[] receiver) {
        if (this.mySubdiagonal != null) {
            this.mySubdiagonal.supplyTo(receiver);
        } else {
            Arrays.fill(receiver, PrimitiveMath.ZERO);
        }
    }

    public void supplySuperdiagonalTo(double[] receiver) {
        if (this.mySuperdiagonal != null) {
            this.mySuperdiagonal.supplyTo(receiver);
        } else {
            Arrays.fill(receiver, PrimitiveMath.ZERO);
        }
    }

    @Override
    public void supplyTo(TransformableRegion<N> consumer) {
        block12: {
            long i;
            block11: {
                long i2;
                consumer.reset();
                if (!this.isPrimitive()) break block11;
                if (this.myMainDiagonal != null) {
                    for (i2 = 0L; i2 < this.myMainDiagonal.count(); ++i2) {
                        consumer.set(i2, i2, this.myMainDiagonal.doubleValue(i2));
                    }
                }
                if (this.mySubdiagonal != null) {
                    for (i2 = 0L; i2 < this.mySubdiagonal.count(); ++i2) {
                        consumer.set(i2 + 1L, i2, this.mySubdiagonal.doubleValue(i2));
                    }
                }
                if (this.mySuperdiagonal == null) break block12;
                for (i2 = 0L; i2 < this.mySuperdiagonal.count(); ++i2) {
                    consumer.set(i2, i2 + 1L, this.mySuperdiagonal.doubleValue(i2));
                }
                break block12;
            }
            if (this.myMainDiagonal != null) {
                for (i = 0L; i < this.myMainDiagonal.count(); ++i) {
                    consumer.set(i, i, (Comparable<?>)this.myMainDiagonal.get(i));
                }
            }
            if (this.mySubdiagonal != null) {
                for (i = 0L; i < this.mySubdiagonal.count(); ++i) {
                    consumer.set(i + 1L, i, (Comparable<?>)this.mySubdiagonal.get(i));
                }
            }
            if (this.mySuperdiagonal != null) {
                for (i = 0L; i < this.mySuperdiagonal.count(); ++i) {
                    consumer.set(i, i + 1L, (Comparable<?>)this.mySuperdiagonal.get(i));
                }
            }
        }
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (this.myMainDiagonal != null && row == col) {
            return this.myScalarFactory.convert((Comparable<?>)this.myMainDiagonal.get(row));
        }
        if (this.mySuperdiagonal != null && col - row == 1L) {
            return this.myScalarFactory.convert((Comparable<?>)this.mySuperdiagonal.get(row));
        }
        if (this.mySubdiagonal != null && row - col == 1L) {
            return this.myScalarFactory.convert((Comparable<?>)this.mySubdiagonal.get(col));
        }
        return this.myScalarFactory.zero();
    }

    public static class Builder<N extends Comparable<N>, D extends Access1D<?>>
    implements Supplier<DiagonalStore<N, D>> {
        private final PhysicalStore.Factory<N, ?> myFactory;
        private final D myMainDiagonal;
        private D mySubdiagonal = null;
        private D mySuperdiagonal = null;

        Builder(PhysicalStore.Factory<N, ?> factory, D mainDiagonal) {
            this.myFactory = factory;
            this.myMainDiagonal = mainDiagonal;
        }

        @Override
        public DiagonalStore<N, D> get() {
            long dim = this.dimension();
            return new DiagonalStore<N, D>(this.myFactory, dim, dim, this.myMainDiagonal, this.mySuperdiagonal, this.mySubdiagonal);
        }

        public Builder<N, D> subdiagonal(D subdiagonal) {
            this.mySubdiagonal = subdiagonal;
            return this;
        }

        public Builder<N, D> superdiagonal(D superdiagonal) {
            this.mySuperdiagonal = superdiagonal;
            return this;
        }

        private int dimension() {
            if (this.myMainDiagonal != null) {
                return Math.toIntExact(this.myMainDiagonal.count());
            }
            if (this.mySuperdiagonal != null) {
                return Math.toIntExact(this.mySuperdiagonal.count() + 1L);
            }
            if (this.mySubdiagonal != null) {
                return Math.toIntExact(this.mySubdiagonal.count() + 1L);
            }
            return 0;
        }
    }
}

