/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.convex.ConvexData;
import org.ojalgo.optimisation.convex.ConvexObjectiveFunction;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.convex.DirectASS;
import org.ojalgo.optimisation.convex.IterativeASS;
import org.ojalgo.optimisation.convex.QPESolver;
import org.ojalgo.optimisation.convex.UnconstrainedSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

abstract class BasePrimitiveSolver
extends ConvexSolver
implements UpdatableSolver {
    private static final String Q_NOT_POSITIVE_SEMIDEFINITE = "Q not positive semidefinite!";
    private static final String Q_NOT_SYMMETRIC = "Q not symmetric!";
    static final PhysicalStore.Factory<Double, Primitive64Store> MATRIX_FACTORY = Primitive64Store.FACTORY;
    private final ConvexData<Double> myMatrices;
    private boolean myPatchedQ = false;
    private final Primitive64Store mySolutionX;
    private final MatrixDecomposition.Solver<Double> mySolverGeneral;
    private final MatrixDecomposition.Solver<Double> mySolverQ;
    private boolean myZeroQ = false;

    static ConvexSolver.Builder builder(MatrixStore<Double>[] matrices) {
        return new ConvexSolver.Builder(matrices);
    }

    static BasePrimitiveSolver newSolver(ConvexData<Double> data, Optimisation.Options options) {
        if (data.countInequalityConstraints() > 0) {
            if (options.sparse == null || options.sparse.booleanValue()) {
                return new IterativeASS(data, options);
            }
            return new DirectASS(data, options);
        }
        if (data.countEqualityConstraints() > 0) {
            return new QPESolver(data, options);
        }
        return new UnconstrainedSolver(data, options);
    }

    static ConvexSolver of(MatrixStore<Double>[] matrices) {
        return (ConvexSolver)BasePrimitiveSolver.builder(matrices).build();
    }

    static ConvexObjectiveFunction<Double> toObjectiveFunction(MatrixStore<?> mtrxQ, MatrixStore<?> mtrxC) {
        if (mtrxQ == null && mtrxC == null) {
            ProgrammingError.throwWithMessage("Both parameters can't be null!", new Object[0]);
        }
        Primitive64Store tmpQ = null;
        Primitive64Store tmpC = null;
        tmpQ = mtrxQ == null ? (Primitive64Store)Primitive64Store.FACTORY.make(mtrxC.count(), mtrxC.count()) : (mtrxQ instanceof Primitive64Store ? (Primitive64Store)mtrxQ : (Primitive64Store)Primitive64Store.FACTORY.copy(mtrxQ));
        tmpC = mtrxC == null ? (Primitive64Store)Primitive64Store.FACTORY.make(tmpQ.countRows(), 1L) : (mtrxC instanceof Primitive64Store ? (Primitive64Store)mtrxC : (Primitive64Store)Primitive64Store.FACTORY.copy(mtrxC));
        return new ConvexObjectiveFunction<Double>(tmpQ, tmpC);
    }

    BasePrimitiveSolver(ConvexData<Double> convexSolverBuilder, Optimisation.Options optimisationOptions) {
        super(optimisationOptions);
        this.myMatrices = convexSolverBuilder;
        this.mySolutionX = (Primitive64Store)MATRIX_FACTORY.make((long)this.countVariables(), 1L);
        PhysicalStore<Double> mtrxQ = this.getMatrixQ();
        ConvexSolver.Configuration convexOptions = optimisationOptions.convex();
        this.mySolverQ = convexOptions.newSolverSPD(mtrxQ);
        this.mySolverGeneral = convexOptions.newSolverGeneral(mtrxQ);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myMatrices.reset();
    }

    @Override
    public UpdatableSolver.EntityMap getEntityMap() {
        return null;
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (this.initialise(kickStarter)) {
            this.resetIterationsCount();
            if (this.isIteratingPossible()) {
                do {
                    this.performIteration();
                } while (this.isIterationAllowed() && this.needsAnotherIteration());
            }
        }
        return this.buildResult();
    }

    public String toString() {
        return this.myMatrices.toString();
    }

    protected Optimisation.Result buildResult() {
        MatrixStore<Double> solution = this.extractSolution();
        double value = this.evaluateFunction(solution);
        Optimisation.State state = this.getState();
        return new Optimisation.Result(state, value, solution);
    }

    protected boolean computeGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.mySolverGeneral.compute(matrix);
    }

    protected int countEqualityConstraints() {
        return this.myMatrices.countEqualityConstraints();
    }

    protected int countInequalityConstraints() {
        return this.myMatrices.countInequalityConstraints();
    }

    protected int countVariables() {
        return this.myMatrices.countVariables();
    }

    protected double evaluateFunction(Access1D<?> solution) {
        PhysicalStore<Double> tmpX = this.getSolutionX();
        return tmpX.transpose().multiply(this.getMatrixQ().multiply((Double)((Object)tmpX))).multiply(0.5).subtract(tmpX.transpose().multiply(this.getMatrixC())).doubleValue(0L);
    }

    protected MatrixStore<Double> extractSolution() {
        return this.getSolutionX().copy();
    }

    protected abstract Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationKKT();

    protected abstract Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationRHS();

    protected MatrixStore<Double> getMatrixAE() {
        return this.myMatrices.getAE();
    }

    protected SparseArray<Double> getMatrixAE(int row) {
        return this.myMatrices.getAE(row);
    }

    protected RowsSupplier<Double> getMatrixAE(int[] rows) {
        return this.myMatrices.getAE(rows);
    }

    protected MatrixStore<Double> getMatrixAI() {
        return this.myMatrices.getAI();
    }

    protected SparseArray<Double> getMatrixAI(int row) {
        return this.myMatrices.getAI(row);
    }

    protected RowsSupplier<Double> getMatrixAI(int[] rows) {
        return this.myMatrices.getAI(rows);
    }

    protected MatrixStore<Double> getMatrixBE() {
        return this.myMatrices.getBE();
    }

    protected MatrixStore<Double> getMatrixBI() {
        return this.myMatrices.getBI();
    }

    protected double getMatrixBI(int row) {
        return this.myMatrices.getBI().doubleValue(row);
    }

    protected MatrixStore<Double> getMatrixBI(int[] selector) {
        return this.myMatrices.getBI().rows(selector);
    }

    protected MatrixStore<Double> getMatrixC() {
        MultiaryFunction.TwiceDifferentiable objective = this.myMatrices.getObjective();
        return ((ConvexObjectiveFunction)objective).linear();
    }

    protected PhysicalStore<Double> getMatrixQ() {
        MultiaryFunction.TwiceDifferentiable objective = this.myMatrices.getObjective();
        return ((ConvexObjectiveFunction)objective).quadratic();
    }

    protected int getRankGeneral() {
        if (this.mySolverGeneral instanceof MatrixDecomposition.RankRevealing) {
            return ((MatrixDecomposition.RankRevealing)((Object)this.mySolverGeneral)).getRank();
        }
        if (this.mySolverGeneral.isSolvable()) {
            return this.mySolverGeneral.getColDim();
        }
        return 0;
    }

    protected MatrixStore<Double> getSolutionGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.mySolverGeneral.getSolution(rhs);
    }

    protected MatrixStore<Double> getSolutionGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.mySolverGeneral.getSolution(rhs, preallocated);
    }

    protected MatrixStore<Double> getSolutionQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.mySolverQ.getSolution(rhs);
    }

    protected MatrixStore<Double> getSolutionQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.mySolverQ.getSolution(rhs, preallocated);
    }

    protected PhysicalStore<Double> getSolutionX() {
        return this.mySolutionX;
    }

    protected boolean hasEqualityConstraints() {
        return this.myMatrices.countEqualityConstraints() > 0;
    }

    protected boolean hasInequalityConstraints() {
        return this.myMatrices.countInequalityConstraints() > 0;
    }

    protected boolean initialise(Optimisation.Result kickStarter) {
        PhysicalStore<Double> matrixQ = this.getMatrixQ();
        this.setState(Optimisation.State.VALID);
        boolean symmetric = true;
        if (this.options.validate && !matrixQ.isHermitian()) {
            symmetric = false;
            this.setState(Optimisation.State.INVALID);
            if (!this.isLogDebug()) {
                throw new IllegalArgumentException(Q_NOT_SYMMETRIC);
            }
            this.log(Q_NOT_SYMMETRIC, matrixQ);
        }
        this.myPatchedQ = false;
        this.myZeroQ = false;
        if (!this.mySolverQ.compute(matrixQ)) {
            double small;
            double largest = (Double)matrixQ.aggregateAll(Aggregator.LARGEST);
            if (largest > (small = this.options.convex().smallDiagonal())) {
                matrixQ.modifyDiagonal(PrimitiveMath.ADD.by(small * largest));
                this.mySolverQ.compute(matrixQ);
                this.myPatchedQ = true;
            } else {
                this.myZeroQ = true;
            }
        }
        boolean semidefinite = true;
        if (this.options.validate && !this.mySolverQ.isSolvable()) {
            Eigenvalue<Double> decompEvD = Eigenvalue.PRIMITIVE.make(matrixQ, true);
            decompEvD.computeValuesOnly(matrixQ);
            Array1D<ComplexNumber> eigenvalues = decompEvD.getEigenvalues();
            decompEvD.reset();
            for (ComplexNumber eigval : eigenvalues) {
                if (!(eigval.doubleValue() < PrimitiveMath.ZERO && !eigval.isSmall(PrimitiveMath.TEN)) && eigval.isReal()) continue;
                semidefinite = false;
                this.setState(Optimisation.State.INVALID);
                if (!this.isLogDebug()) {
                    throw new IllegalArgumentException(Q_NOT_POSITIVE_SEMIDEFINITE);
                }
                this.log(Q_NOT_POSITIVE_SEMIDEFINITE, new Object[0]);
                this.log("The eigenvalues are: {}", eigenvalues);
            }
        }
        return symmetric && semidefinite;
    }

    protected boolean isIteratingPossible() {
        return true;
    }

    protected boolean isSolvableGeneral() {
        return this.mySolverGeneral.isSolvable();
    }

    protected boolean isSolvableQ() {
        return this.mySolverQ.isSolvable();
    }

    protected abstract boolean needsAnotherIteration();

    protected abstract void performIteration();

    protected boolean solveFullKKT(PhysicalStore<Double> preallocated) {
        if (this.computeGeneral(this.getIterationKKT())) {
            this.getSolutionGeneral(this.getIterationRHS(), preallocated);
            return true;
        }
        if (this.isLogDebug()) {
            this.log("KKT system unsolvable!", new Object[0]);
            this.log("KKT", (Access2D)this.getIterationKKT().collect(Primitive64Store.FACTORY));
            this.log("RHS", (Access2D)this.getIterationRHS().collect(Primitive64Store.FACTORY));
        }
        return false;
    }

    protected Optimisation.Result solveLP() {
        Optimisation.Result resultLP = LinearSolver.solve(this.myMatrices, this.options, !this.myZeroQ);
        if (!this.myZeroQ && resultLP.getState().isFeasible()) {
            return resultLP.withState(Optimisation.State.FEASIBLE);
        }
        return resultLP;
    }

    boolean isPatchedQ() {
        return this.myPatchedQ;
    }

    boolean isZeroQ() {
        return this.myZeroQ;
    }
}

