/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Transformation1D;

public interface Mutate1D
extends Structure1D {
    public static void copyComplexArgument(Access1D<ComplexNumber> source, Mutate1D destination) {
        long limit = Math.min(source.count(), destination.count());
        for (long i = 0L; i < limit; ++i) {
            destination.set(i, source.get(i).getArgument());
        }
    }

    public static void copyComplexImaginary(Access1D<ComplexNumber> source, Mutate1D destination) {
        long limit = Math.min(source.count(), destination.count());
        for (long i = 0L; i < limit; ++i) {
            destination.set(i, source.get(i).getImaginary());
        }
    }

    public static void copyComplexModulus(Access1D<ComplexNumber> source, Mutate1D destination) {
        long limit = Math.min(source.count(), destination.count());
        for (long i = 0L; i < limit; ++i) {
            destination.set(i, source.get(i).getModulus());
        }
    }

    public static void copyComplexModulusAndArgument(Access1D<ComplexNumber> source, Mutate1D modDest, Mutate1D argDest) {
        long limit = MissingMath.min(source.count(), modDest.count(), argDest.count());
        for (long i = 0L; i < limit; ++i) {
            ComplexNumber cmplx = source.get(i);
            modDest.set(i, cmplx.getModulus());
            argDest.set(i, cmplx.getArgument());
        }
    }

    public static void copyComplexReal(Access1D<ComplexNumber> source, Mutate1D destination) {
        long limit = Math.min(source.count(), destination.count());
        for (long i = 0L; i < limit; ++i) {
            destination.set(i, source.get(i).getReal());
        }
    }

    public static void copyComplexRealAndImaginary(Access1D<ComplexNumber> source, Mutate1D realDest, Mutate1D imagDest) {
        long limit = MissingMath.min(source.count(), realDest.count(), imagDest.count());
        for (long i = 0L; i < limit; ++i) {
            ComplexNumber cmplx = source.get(i);
            realDest.set(i, cmplx.getReal());
            imagDest.set(i, cmplx.getImaginary());
        }
    }

    default public void reset() {
        long limit = this.count();
        for (long i = 0L; i < limit; ++i) {
            this.set(i, PrimitiveMath.ZERO);
        }
    }

    default public void set(long index, byte value) {
        this.set(index, (short)value);
    }

    public void set(long var1, Comparable<?> var3);

    public void set(long var1, double var3);

    default public void set(long index, float value) {
        this.set(index, (double)value);
    }

    default public void set(long index, int value) {
        this.set(index, (long)value);
    }

    default public void set(long index, long value) {
        this.set(index, (double)value);
    }

    default public void set(long index, short value) {
        this.set(index, (int)value);
    }

    public static interface Sortable
    extends Structure1D {
        public void sortAscending();

        public void sortDescending();
    }

    public static interface Receiver<N extends Comparable<N>>
    extends Mutate1D,
    Fillable<N>,
    Consumer<Access1D<?>> {
        @Override
        default public void accept(Access1D<?> supplied) {
            if (!this.isAcceptable(supplied)) {
                throw new ProgrammingError("Not acceptable!");
            }
            long limit = Math.min(this.count(), supplied.count());
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Comparable<?>)supplied.get(i));
            }
        }

        default public boolean isAcceptable(Structure1D supplier) {
            return this.count() >= supplier.count();
        }
    }

    public static interface ModifiableReceiver<N extends Comparable<N>>
    extends Modifiable<N>,
    Receiver<N>,
    Access1D<N> {
        public void modifyAny(Transformation1D<N> var1);
    }

    public static interface Modifiable<N extends Comparable<N>>
    extends Structure1D {
        default public void add(long index, byte addend) {
            this.add(index, (short)addend);
        }

        public void add(long var1, Comparable<?> var3);

        public void add(long var1, double var3);

        default public void add(long index, float addend) {
            this.add(index, (double)addend);
        }

        default public void add(long index, int addend) {
            this.add(index, (long)addend);
        }

        default public void add(long index, long addend) {
            this.add(index, (double)addend);
        }

        default public void add(long index, short addend) {
            this.add(index, (int)addend);
        }

        default public void modifyAll(UnaryFunction<N> modifier) {
            this.modifyRange(0L, this.count(), modifier);
        }

        default public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
            long limit = Math.min(left.count(), this.count());
            for (long i = 0L; i < limit; ++i) {
                this.modifyOne(i, function.first(left.get(i)));
            }
        }

        default public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
            long limit = Math.min(this.count(), right.count());
            for (long i = 0L; i < limit; ++i) {
                this.modifyOne(i, function.second(right.get(i)));
            }
        }

        public void modifyOne(long var1, UnaryFunction<N> var3);

        default public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
            for (long i = first; i < limit; ++i) {
                this.modifyOne(i, modifier);
            }
        }
    }

    public static interface Mixable<N extends Comparable<N>>
    extends Structure1D {
        public double mix(long var1, BinaryFunction<N> var3, double var4);

        public N mix(long var1, BinaryFunction<N> var3, N var4);
    }

    public static interface Fillable<N extends Comparable<N>>
    extends Mutate1D {
        default public void fillAll(N value) {
            this.fillRange(0L, this.count(), value);
        }

        default public void fillAll(NullaryFunction<?> supplier) {
            this.fillRange(0L, this.count(), supplier);
        }

        default public void fillMatching(Access1D<?> values) {
            long limit = Math.min(this.count(), values.count());
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(i, values, i);
            }
        }

        default public void fillMatching(Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
            long limit = Math.min(left.count(), right.count());
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(i, function.invoke(left.get(i), right.get(i)));
            }
        }

        default public void fillMatching(UnaryFunction<N> function, Access1D<N> arguments) {
            long limit = Math.min(this.count(), arguments.count());
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(i, function.invoke(arguments.get(i)));
            }
        }

        @Deprecated
        default public void fillOne(long index, Access1D<?> values, long valueIndex) {
            this.set(index, (Comparable<?>)values.get(valueIndex));
        }

        @Deprecated
        default public void fillOne(long index, N value) {
            this.set(index, (Comparable<?>)value);
        }

        @Deprecated
        default public void fillOne(long index, NullaryFunction<?> supplier) {
            this.set(index, (Comparable<?>)supplier.get());
        }

        default public void fillRange(long first, long limit, N value) {
            for (long i = first; i < limit; ++i) {
                this.fillOne(i, value);
            }
        }

        default public void fillRange(long first, long limit, NullaryFunction<?> supplier) {
            for (long i = first; i < limit; ++i) {
                this.fillOne(i, supplier);
            }
        }
    }
}

