/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui;

import fr.profi.mgfboost.ui.ConfigurationDialog;
import fr.profi.mgfboost.ui.MS2CollectionPanel;
import fr.profi.mgfboost.ui.MS2CollectionRenderer;
import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mgfboost.ui.command.ECleanMgfCommand;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.MaxQuantCreateMgfCommand;
import fr.profi.mgfboost.ui.command.MergeMgfCommand;
import fr.profi.mgfboost.ui.command.MzdbCreateMgfCommand;
import fr.profi.mgfboost.ui.command.PCleanMgfCommand;
import fr.profi.mgfboost.ui.model.MS2Collection;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzscope.MSMSSpectrum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MS2CollectionManager {
    private static final Logger logger = LoggerFactory.getLogger(MS2CollectionManager.class);
    private final JPopupMenu popupMenu;
    private final MainPanel mainPanel;
    private final JList<MS2Collection> ms2CollectionList;
    private final DefaultListModel<MS2Collection> ms2CollectionListModel;
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private int runningTasksIncr = 0;

    public MS2CollectionManager(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.commands.put(CommandArguments.MzDBCreateMgfCommand.class.getSimpleName(), new MzdbCreateMgfCommand());
        this.commands.put(CommandArguments.PCleanCommand.class.getSimpleName(), new PCleanMgfCommand());
        this.commands.put(CommandArguments.MgfCleanerCommand.class.getSimpleName(), new ECleanMgfCommand());
        this.commands.put(CommandArguments.MaxQuantMGFCommand.class.getSimpleName(), new MaxQuantCreateMgfCommand());
        this.commands.put(CommandArguments.MgfMergerCommand.class.getSimpleName(), new MergeMgfCommand());
        this.ms2CollectionList = new JList();
        this.ms2CollectionListModel = new DefaultListModel();
        this.ms2CollectionList.setModel(this.ms2CollectionListModel);
        this.ms2CollectionList.setCellRenderer(new MS2CollectionRenderer(this.ms2CollectionList.getCellRenderer()));
        this.popupMenu = new JPopupMenu();
        this.initPopupMenu();
        this.ms2CollectionList.setComponentPopupMenu(this.popupMenu);
        this.ms2CollectionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MS2CollectionManager.this.updatePopupMenu();
                if (MS2CollectionManager.this.ms2CollectionList.getSelectedIndex() > -1 && SwingUtilities.isRightMouseButton(evt)) {
                    MS2CollectionManager.this.popupMenu.show((JComponent)evt.getSource(), evt.getX(), evt.getY());
                } else if (evt.getClickCount() == 2) {
                    MS2CollectionManager.this.viewCollectionAction();
                }
            }
        });
    }

    private void initPopupMenu() {
        this.popupMenu.removeAll();
        JMenuItem viewRawFileMI = new JMenuItem();
        viewRawFileMI.setText("View");
        viewRawFileMI.addActionListener(actionEvent -> this.viewCollectionAction());
        this.popupMenu.add(viewRawFileMI);
        JMenuItem closeRawFileMI = new JMenuItem();
        closeRawFileMI.setText("Close");
        closeRawFileMI.addActionListener(actionEvent -> this.closeCollectionAction());
        this.popupMenu.add(closeRawFileMI);
    }

    private void updatePopupMenu() {
        List fileTypes;
        List<MS2Collection> selectedCollections = this.ms2CollectionList.getSelectedValuesList();
        if (selectedCollections.size() > 0) {
            this.initPopupMenu();
            this.popupMenu.addSeparator();
        }
        if ((fileTypes = selectedCollections.stream().map(c -> c.getFileType()).distinct().collect(Collectors.toList())).size() == 1) {
            switch ((MainPanel.FileType)((Object)fileTypes.get(0))) {
                case MGF: {
                    this.addMGFActions(selectedCollections);
                    break;
                }
                case MZDB: {
                    this.addMzdbActions(selectedCollections);
                    break;
                }
                case MAXQUANT: {
                    this.addMQActions(selectedCollections);
                }
            }
        }
    }

    private void addMQActions(List<MS2Collection> selectedCollections) {
        if (MS2CollectionManager.isCommandSelectionConsistent(selectedCollections, this.commands.get(CommandArguments.MaxQuantMGFCommand.class.getSimpleName()))) {
            JMenuItem createMGFMI = new JMenuItem();
            createMGFMI.setActionCommand(CommandArguments.MaxQuantMGFCommand.class.getSimpleName());
            createMGFMI.setText("Create MGF");
            createMGFMI.addActionListener(this::performAction);
            this.popupMenu.add(createMGFMI);
        }
    }

    private static boolean isCommandSelectionConsistent(List<MS2Collection> selectedCollections, ICommand command) {
        return command.getExecutionMode().equals((Object)ICommand.ExecutionMode.SINGLE_FILE) && selectedCollections.size() == 1 || command.getExecutionMode().equals((Object)ICommand.ExecutionMode.BATCH_OF_SINGLE_FILES) && selectedCollections.size() > 0 || command.getExecutionMode().equals((Object)ICommand.ExecutionMode.PAIRS_OF_FILES) && selectedCollections.size() == 2;
    }

    private void addMzdbActions(List<MS2Collection> selectedCollections) {
        if (MS2CollectionManager.isCommandSelectionConsistent(selectedCollections, this.commands.get(CommandArguments.MzDBCreateMgfCommand.class.getSimpleName()))) {
            JMenuItem createMGFMI = new JMenuItem();
            createMGFMI.setActionCommand(CommandArguments.MzDBCreateMgfCommand.class.getSimpleName());
            createMGFMI.setText("Create MGF");
            createMGFMI.addActionListener(this::performAction);
            this.popupMenu.add(createMGFMI);
        }
    }

    private void addMGFActions(List<MS2Collection> selectedCollections) {
        if (MS2CollectionManager.isCommandSelectionConsistent(selectedCollections, this.commands.get(CommandArguments.PCleanCommand.class.getSimpleName()))) {
            JMenuItem pCleanMGFMI = new JMenuItem();
            pCleanMGFMI.setActionCommand(CommandArguments.PCleanCommand.class.getSimpleName());
            pCleanMGFMI.setText("Clean MGF with pClean");
            pCleanMGFMI.addActionListener(this::performAction);
            this.popupMenu.add(pCleanMGFMI);
        }
        if (MS2CollectionManager.isCommandSelectionConsistent(selectedCollections, this.commands.get(CommandArguments.MgfCleanerCommand.class.getSimpleName()))) {
            JMenuItem eCleanMGFMI = new JMenuItem();
            eCleanMGFMI.setActionCommand(CommandArguments.MgfCleanerCommand.class.getSimpleName());
            eCleanMGFMI.setText("Clean MGF with edyp Clean (eClean)");
            eCleanMGFMI.addActionListener(this::performAction);
            this.popupMenu.add(eCleanMGFMI);
        }
        if (MS2CollectionManager.isCommandSelectionConsistent(selectedCollections, this.commands.get(CommandArguments.MgfMergerCommand.class.getSimpleName()))) {
            JMenuItem mergeMGFMI = new JMenuItem();
            mergeMGFMI.setActionCommand(CommandArguments.MgfMergerCommand.class.getSimpleName());
            mergeMGFMI.setText("Merge MGF");
            mergeMGFMI.addActionListener(this::performAction);
            this.popupMenu.add(mergeMGFMI);
        }
    }

    private void performAction(ActionEvent actionEvent) {
        final List<MS2Collection> selectedCollections = this.ms2CollectionList.getSelectedValuesList();
        final ICommand command = this.commands.get(actionEvent.getActionCommand());
        ConfigurationDialog configurationDialog = new ConfigurationDialog(command, selectedCollections);
        configurationDialog.setLocationRelativeTo(this.mainPanel);
        configurationDialog.setVisible(true);
        if (configurationDialog.isValidated()) {
            this.updateExecutionStatus("Command running ...", 1);
            SwingWorker<Integer, MS2Collection> worker = new SwingWorker<Integer, MS2Collection>(){

                @Override
                protected Integer doInBackground() throws Exception {
                    if (command.getExecutionMode().equals((Object)ICommand.ExecutionMode.SINGLE_FILE) || command.getExecutionMode().equals((Object)ICommand.ExecutionMode.BATCH_OF_SINGLE_FILES)) {
                        for (MS2Collection c : selectedCollections) {
                            this.publish(command.execute(c.getFile()));
                        }
                    } else if (command.getExecutionMode().equals((Object)ICommand.ExecutionMode.PAIRS_OF_FILES)) {
                        this.publish(command.execute(((MS2Collection)selectedCollections.get(0)).getFile(), ((MS2Collection)selectedCollections.get(1)).getFile()));
                    }
                    return selectedCollections.size();
                }

                @Override
                protected void process(List<MS2Collection> chunks) {
                    for (MS2Collection outputCollection : chunks) {
                        if (outputCollection == null || !outputCollection.getFile().exists()) continue;
                        MS2CollectionManager.this.ms2CollectionListModel.addElement(outputCollection);
                    }
                }

                @Override
                protected void done() {
                    try {
                        MS2CollectionManager.this.updateExecutionStatus("", -1);
                    }
                    catch (Exception e) {
                        logger.error("Error during command execution ", (Throwable)e);
                    }
                }
            };
            worker.execute();
        }
    }

    private void viewCollectionAction() {
        final MS2Collection selectedCollection = this.ms2CollectionList.getSelectedValuesList().get(0);
        this.updateExecutionStatus("Preparing display ...", 1);
        this.ms2CollectionList.setEnabled(false);
        SwingWorker<List<MSMSSpectrum>, Void> worker = new SwingWorker<List<MSMSSpectrum>, Void>(){

            @Override
            protected List<MSMSSpectrum> doInBackground() throws Exception {
                return selectedCollection.getSpectrumList();
            }

            @Override
            protected void done() {
                try {
                    MS2CollectionManager.this.updateExecutionStatus("", -1);
                    List spectra = (List)this.get();
                    if (spectra != null && !spectra.isEmpty()) {
                        MS2CollectionManager.this.mainPanel.getTabbedPane().add(selectedCollection.getName(), (Component)((Object)new MS2CollectionPanel(spectra, MS2CollectionManager.this.mainPanel)));
                    } else {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Sorry, the selected operation is not yet implemented. Please generate an MGF file\nfrom the selected collection and then visualize the MS2 spectrum from the generated MGF.");
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot load MS2 spectrum from the selected collection", (Throwable)e);
                }
                finally {
                    MS2CollectionManager.this.ms2CollectionList.setEnabled(true);
                }
            }
        };
        worker.execute();
    }

    private void updateExecutionStatus(String text, int increment) {
        this.runningTasksIncr += increment;
        String label = increment > 0 && this.runningTasksIncr > 1 || increment < 0 && this.runningTasksIncr > 0 ? this.runningTasksIncr + " tasks running ..." : text;
        this.mainPanel.displayExecutionStatus(label, this.runningTasksIncr > 0);
    }

    private void closeCollectionAction() {
        for (MS2Collection collection : this.ms2CollectionList.getSelectedValuesList()) {
            this.ms2CollectionListModel.removeElement(collection);
        }
    }

    public boolean addToMS2Collection(File file, MainPanel.FileType type) {
        this.ms2CollectionListModel.addElement(new MS2Collection(file, type));
        return false;
    }

    public JList<MS2Collection> getMs2CollectionList() {
        return this.ms2CollectionList;
    }
}

