/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui;

import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mzscope.ui.RawMinerFrame;
import fr.profi.util.version.IVersion;
import fr.proline.studio.ImageUtilities;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFrame
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(MainFrame.class);
    private final MainPanel mainPanel;

    public MainFrame() {
        ServiceLoader<IVersion> versionLoader = ServiceLoader.load(IVersion.class);
        Iterator<IVersion> iter = versionLoader.iterator();
        String version = "snapshot";
        while (iter.hasNext()) {
            IVersion v = iter.next();
            if (!v.getModuleName().equalsIgnoreCase("mzScope")) continue;
            version = v.getVersion();
        }
        ImageIcon appIcon = ImageUtilities.loadImageIcon((String)"fr/profi/mgfboost/images/mgfBoost.png", (boolean)false);
        this.setIconImage(appIcon.getImage());
        this.setTitle("MgfBoost " + version);
        this.mainPanel = new MainPanel();
        this.initComponents();
        this.getContentPane().add(this.mainPanel);
        this.setSize(700, 500);
        this.setDefaultCloseOperation(3);
    }

    private void initComponents() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        jMenuBar.add(fileMenu);
        JMenu openMenu = new JMenu("Open");
        fileMenu.add(openMenu);
        JMenuItem menuItem = new JMenuItem("MzDB File");
        menuItem.addActionListener(this::openMzdbFileActionPerformed);
        openMenu.add(menuItem);
        menuItem = new JMenuItem("MGF File");
        menuItem.addActionListener(this::openMGFFileActionPerformed);
        openMenu.add(menuItem);
        menuItem = new JMenuItem("MaxQuant Folder");
        menuItem.addActionListener(this::openMQFileActionPerformed);
        openMenu.add(menuItem);
        this.setJMenuBar(jMenuBar);
    }

    private void openMQFileActionPerformed(ActionEvent actionEvent) {
        this.mainPanel.openFileAction(MainPanel.FileType.MAXQUANT.name().toLowerCase());
    }

    private void openMGFFileActionPerformed(ActionEvent actionEvent) {
        this.mainPanel.openFileAction(MainPanel.FileType.MGF.name().toLowerCase());
    }

    private void openMzdbFileActionPerformed(ActionEvent evt) {
        this.mainPanel.openFileAction(MainPanel.FileType.MZDB.name().toLowerCase());
    }

    public static void main(String[] args) {
        try {
            Locale.setDefault(new Locale("en", "US"));
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(RawMinerFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new MainFrame().setVisible(true));
    }
}

